package net.sf.seaf.util;

import java.util.Collection;
import java.util.Map;

import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * Converts Object to String using ReflectionToStringBuilder and
 * RecursiveReflectionToStringStyle. Fields are handled recursively, for
 * detailed info see RecursiveReflectionToStringStyle.
 * 
 * @author pspicka
 * 
 */
public class RecursiveReflectionToStringBuilder {

	private RecursiveReflectionToStringStyle style = RecursiveReflectionToStringStyle.DEFAULT_RR_STYLE;

	/**
	 * Recursively converts Object to String.
	 * 
	 * @param value
	 * @return string representation
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public String toString(Object value) {
		if (value != null && value instanceof String) {
			return new ToStringBuilder("", getStyle()).append(value).toString();
		}
		if (value != null && value instanceof Collection) {
			return new ToStringBuilder(value, getStyle()).append(
					((Collection) value).toArray(new Object[0])).toString();
		}
		if (value != null && value instanceof Map) {
			return new ToStringBuilder(value, getStyle()).append(
					((Map) value).entrySet().toArray(new Object[0])).toString();
		}
		return new ReflectionToStringBuilder(value, getStyle()).toString();
	}

	// standard getters / setters

	private RecursiveReflectionToStringStyle getStyle() {
		return style;
	}

	public final void setStyle(RecursiveReflectionToStringStyle style) {
		this.style = style;
	}

}
