package net.sf.seaf.util;

import net.sf.seaf.exception.SeafClassLoadingException;

/**
 * Utility methods for factory-related functionality.
 */
public class FactoryUtils {

	private static FactoryUtils instance = new FactoryUtils();

	/**
	 * Returns a default instance of FactoryUtils.
	 * 
	 * @return A default instance of FactoryUtils
	 */
	public static FactoryUtils getInstance() {
		return instance;
	}

	/**
	 * Get a class of a given type.
	 * 
	 * @param fullName
	 *            The full name of the class to load
	 * @param type
	 *            The type to which the class can be casted
	 * @return The loaded class
	 * @throws SeafClassLoadingException
	 *             When the class cannot be loaded
	 */
	public <Type> Class<Type> getClassForName(String fullName, Class<Type> type)
			throws SeafClassLoadingException {
		try {
			@SuppressWarnings("unchecked")
			Class<Type> clazz = (Class<Type>) Class.forName(fullName);
			return clazz;
		} catch (ClassNotFoundException e) {
			throw new SeafClassLoadingException("Cannot find class for name: "
					+ fullName, e);
		}
	}

}
