package net.sf.seaf.factory.impl.support;

import net.sf.seaf.factory.Factory;

/**
 * Base class for factories that delegate instantiation to an instantiating
 * factory.
 */
public class DelegatingFactoryBase {

	private Factory instantiatingFactory;

	/**
	 * Default empty constructor. The instantiating factory must be set by the
	 * setter method.
	 */
	public DelegatingFactoryBase() {
	}

	/**
	 * Full constructor.
	 * 
	 * @param instantiatingFactory
	 *            The instantiating factory
	 */
	public DelegatingFactoryBase(Factory instantiatingFactory) {
		this.instantiatingFactory = instantiatingFactory;
	}

	/**
	 * Get the instantiating factory.
	 * 
	 * @return The instantiating factory
	 */
	protected final Factory getInstantiatingFactory() {
		return instantiatingFactory;
	}

	/**
	 * Set the instantiating factory.
	 * 
	 * @param instantiatingFactory
	 *            The instantiating factory
	 */
	public final void setInstantiatingFactory(Factory instantiatingFactory) {
		this.instantiatingFactory = instantiatingFactory;
	}

}
