package net.sf.seaf.factory.impl.support;

import java.lang.reflect.Method;

import net.sf.seaf.factory.Proxy;

/**
 * A default base class for proxies. Passes invocations on the proxied object
 * with no added functionality.
 * <p>
 * Subclass and override {@code invoke()} method to add functionality; call
 * {@code super.invoke();} to perform the invocation itself.
 */
public class DefaultProxyBase implements Proxy {

	private Object proxiedObject;

	public Object invoke(Object proxy, Method method, Object[] args)
			throws Throwable {
		return method.invoke(getProxiedObject(), args);
	}

	/**
	 * Get the proxied object.
	 * 
	 * @return The proxied object
	 */
	public final Object getProxiedObject() {
		return proxiedObject;
	}

	public final void setProxiedObject(Object proxiedObject) {
		this.proxiedObject = proxiedObject;
	}

}
