package net.sf.seaf.factory.impl;

import java.lang.reflect.Method;

import net.sf.seaf.exception.SeafInitializationException;
import net.sf.seaf.factory.Factory;
import net.sf.seaf.factory.Initializer;
import net.sf.seaf.factory.impl.support.DelegatingFactoryBase;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetterInitializer extends DelegatingFactoryBase implements
		Initializer<Object> {

	private final Logger log = LoggerFactory.getLogger(SetterInitializer.class);

	public SetterInitializer() {
	}

	public SetterInitializer(Factory instantiatingFactory) {
		super(instantiatingFactory);
	}

	public void initialize(Object instance) {
		log.trace("Initializing instance {}" + instance);
		Method[] methods = instance.getClass().getMethods();
		for (int i = 0; i < methods.length; i++) {
			Method method = methods[i];
			if (isSetter(method)) {
				processSetter(instance, method);
			}
		}
	}

	private void processSetter(Object instance, Method method) {
		Class<?> type = method.getParameterTypes()[0];
		String propertyName = getPropertyName(method);
		log.trace("Retrieving value for property {} of type {}"
				+ " from the instantiating factory", propertyName, type);
		Object value = getInstantiatingFactory().getInstanceOf(type);
		log.trace("Initializing property {} with value {}", propertyName, value);
		try {
			method.invoke(instance, value);
		} catch (Exception e) {
			String message = "Cannot initialize property " + propertyName
					+ " on instance of type " + instance.getClass()
					+ " with value " + value;
			log.error(message, e);
			throw new SeafInitializationException(message, e);
		}
	}

	private boolean isSetter(Method method) {
		return method.getName().startsWith("set")
				&& 1 == method.getParameterTypes().length;
	}

	private String getPropertyName(Method method) {
		String propertyName = method.getName().substring(3);
		if (propertyName.length() > 0)
			return propertyName = propertyName.substring(0, 1).toLowerCase()
					+ propertyName.substring(1);
		return "<empty name>";
	}

}
