package net.sf.seaf.factory;

/**
 * Initializer initializes instances of a given type.
 * 
 * @param <Type>
 *            The type of instances that are accepted by this initializer
 */
public interface Initializer<Type> {

	/**
	 * Initialize an instance.
	 * 
	 * @param instance
	 *            The instance
	 */
	void initialize(Type instance);

}
