package net.sf.seaf.common;

/**
 * Comparison operator enumeration.
 */
public enum Operator {

	/**
	 * Greater than.
	 */
	gt(">", "Greater than"),
	/**
	 * Greater than or equals.
	 */
	ge(">=", "Greater than or equals"),
	/**
	 * Less than.
	 */
	lt("<", "Less than"),
	/**
	 * Less than or equals.
	 */
	le("<=", "Less than or equals"),
	/**
	 * Equals.
	 */
	eq("=", "Equals"),
	/**
	 * Not equals.
	 */
	neq("<>", "Not equals"),
	/**
	 * Like.
	 */
	like("like", "~", "Like"),
	/**
	 * Exists.
	 */
	ex("is not null", "E", "Exists"),
	/**
	 * Not exists.
	 */
	nex("is null", "NE", "Not exists"),
	/**
	 * Greater than if exists.
	 */
	gtex("> or is null", ">E", "Greater than if exists"),
	/**
	 * Greater than or equals if exists.
	 */
	geex(">= or is null", ">=E", "Greater than or equals if exists"),
	/**
	 * Less than if exists.
	 */
	ltex("< or is null", "<E", "Less than if exists"),
	/**
	 * Less than or equals if exists.
	 */
	leex("<= or is null", "<=E", "Less than or equals if exists"),
	/**
	 * Equals if exists.
	 */
	eqex("= or is null", "=E", "Equals if exists"),
	/**
	 * Not equals if exists.
	 */
	neqex("<> or is null", "<>E", "Not equals if exists"),
	/**
	 * Like if exists.
	 */
	likeex("like or is null", "~E", "Like if exists");

	private final String sql;
	private final String label;
	private final String description;

	private Operator(String sql, String description) {
		this.sql = sql;
		this.label = sql;
		this.description = description;
	}

	private Operator(String sql, String label, String description) {
		this.sql = sql;
		this.label = label;
		this.description = description;
	}

	public String getSql() {
		return sql;
	}

	public String getLabel() {
		return label;
	}

	public String getDescription() {
		return description;
	}

}
