<?xml version="1.0" encoding="UTF-8"?>
<stylesheet
	xmlns="http://www.w3.org/1999/XSL/Transform"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:seaf="http://seaf.sf.net/seaf"
	version="2.0">
	<import href="SystemFunctions.xsl" />

	<!-- Extract class name from a full type -->
	<function name="seaf:type-class" as="xs:string">
		<param name="type" as="xs:string" />
		<value-of select="seaf:last-token($type,'\.')" />
	</function>

	<!-- Extract package from a full type -->
	<function name="seaf:type-package" as="xs:string">
		<param name="type" as="xs:string" />
		<value-of select="seaf:strip-last-token($type,'\.','.')" />
	</function>

	<!-- Extract package-based directory from a full type -->
	<function name="seaf:type-dir" as="xs:string">
		<param name="type" as="xs:string" />
		<value-of select="seaf:strip-last-token($type,'\.','/')" />
	</function>

	<!-- Create a class name containing the whole full type given -->
	<function name="seaf:type-full-name" as="xs:string">
		<param name="type" as="xs:string" />
		<value-of
			select="concat(seaf:camel(replace(seaf:type-package($type),'\.',' ')),
				seaf:type-class($type))" />
	</function>

	<!-- Create an attribute name containing the whole full type given -->
	<function name="seaf:type-att-name" as="xs:string">
		<param name="type" as="xs:string" />
		<value-of select="seaf:first-lower(seaf:type-full-name($type))" />
	</function>

	<!-- Return name of a getter method for the given property name -->
	<function name="seaf:getter-name" as="xs:string">
		<param name="name" as="xs:string" />
		<value-of select="concat('get',seaf:java-beans-first-upper($name))" />
	</function>

	<!-- Return name of a boolean getter method for the given property name -->
	<function name="seaf:boolean-getter-name" as="xs:string">
		<param name="name" as="xs:string" />
		<value-of select="concat('is',seaf:java-beans-first-upper($name))" />
	</function>

	<!-- Return name of a setter method for the given property name -->
	<function name="seaf:setter-name" as="xs:string">
		<param name="name" as="xs:string" />
		<value-of select="concat('set',seaf:java-beans-first-upper($name))" />
	</function>

	<!-- Return name of a getter method for the given full type -->
	<function name="seaf:type-get-method" as="xs:string">
		<param name="type" as="xs:string" />
		<value-of select="seaf:getter-name(seaf:type-full-name($type))" />
	</function>

	<!-- Simplified interface to getter/setter generation function -->
	<function name="seaf:getter-setter-declaration">
		<param name="name" as="xs:string" />
		<param name="type" as="xs:string" />
		<value-of select="seaf:getter-setter-declaration(
			$name,$type,(),(),(),(),(),(),(),())"/>
	</function>

	<!-- Generate getter/setter methods for an attribute -->
	<function name="seaf:getter-setter-declaration">
		<param name="name" as="xs:string" />
		<param name="type" as="xs:string" />
		<param name="reverse-single-property" as="xs:string*" />
		<param name="separate-reverse-setter" as="xs:boolean*" />
		<param name="reverse-collection-property" as="xs:string*" />
		<param name="reverse-collection-type" as="xs:string*" />
		<param name="not-null-value" as="xs:string*" />
		<param name="chained-as-type" as="xs:string*" />
		<param name="cast-as" as="xs:string*" />
		<param name="non-final" as="xs:boolean*" />
		<variable name="getter" select="seaf:getter-name($name)" />
		<variable name="setter" select="seaf:setter-name($name)" />

		<value-of select="seaf:getter-declaration-internal($name,$type,'',$getter,$non-final)"/>
		<if test="$type='Boolean'">
			<value-of select="seaf:getter-declaration-internal(
				$name,$type,'boolean ',seaf:boolean-getter-name($name),$non-final)"/>
		</if>

	/**
	 * Default setter for property <value-of select="$name" />.
	 * 
	 * @param <value-of select="$name" /> New value for the <text />
	 	<value-of select="$name" /> property<text />
		<if test="$chained-as-type">
	 * @return this<text />
		</if>
	 */
	public <text />
		<if test="not($non-final)">final </if>
		<choose>
			<when test="$chained-as-type"><value-of select="$chained-as-type"/></when>
			<otherwise>void</otherwise>
		</choose>
		<text> </text>
		<value-of select="$setter" />(<text />
		<value-of select="$type" />
		<text> </text>
		<value-of select="$name" />) {<text />
		<if test="$not-null-value">
		if (null == <value-of select="$name" />)
			<value-of select="$name" /> = <value-of select="$not-null-value" />;<text />
		</if>
		this.<value-of select="$name" /> = <value-of select="$name" />;<text />
		<if test="$reverse-single-property and not($separate-reverse-setter)">
			<value-of select="seaf:single-reverse-set-internal(
				$name,$reverse-single-property,$cast-as)" />
		</if>
		<if test="$chained-as-type">
		return this;<text />
		</if>
	}<text />

	<if test="($reverse-single-property and $separate-reverse-setter) 
		or $reverse-collection-property">

	/**
	 * Setter for property <value-of select="$name" />
	 * that sets also the reverse side of the relation.
	 * 
	 * @param <value-of select="$name" /> New value for the <text />
	 	<value-of select="$name" /> property<text />
		<if test="$chained-as-type">
	 * @return this<text />
		</if>
	 */
	public <text />
		<if test="not($non-final)">final </if>
		<choose>
			<when test="$chained-as-type"><value-of select="$chained-as-type"/></when>
			<otherwise>void</otherwise>
		</choose>
		<text> </text>
		<value-of select="$setter" />_WithReverseSide(<text />
		<value-of select="$type" />
		<text> </text>
		<value-of select="$name" />) {
		<value-of select="$setter" />(<value-of select="$name" />);<text />
		<if test="$reverse-single-property">
			<value-of select="seaf:single-reverse-set-internal(
				$name,$reverse-single-property,$cast-as)" />
		</if>
		<if test="$reverse-collection-property">
		// Set the reverse side of the relation
		if (null != this.<value-of select="$name" />)
			for (<value-of select="$reverse-collection-type" /> item : this.<text />
				<value-of select="$name" />)
				item.<value-of select="seaf:setter-name($reverse-collection-property)" />
					<text />(<text />
			<if test="$cast-as">(<value-of select="$cast-as"/>) </if>
			<text />this);<text />
		</if>
		<if test="$chained-as-type">
		return this;<text />
		</if>
	}<text />
	</if>
	</function>

	<!-- Generate reverse set for single-valued property, internal function -->
	<function name="seaf:single-reverse-set-internal">
		<param name="name" as="xs:string" />
		<param name="reverse-single-property" as="xs:string*" />
		<param name="cast-as" as="xs:string*" />
		// Set the reverse side of the relation
		if (null != <value-of select="$name" /> &amp;&amp; this != <text />
			<value-of select="$name" />.<text />
			<value-of select="seaf:getter-name($reverse-single-property)" />())
			<value-of select="$name" />.<text />
				<value-of select="seaf:setter-name($reverse-single-property)" />(<text />
			<if test="$cast-as">(<value-of select="$cast-as"/>) </if>
			<text />this);<text />
	</function>

	<!-- Generate getter method, internal function -->
	<function name="seaf:getter-declaration-internal">
		<param name="name" as="xs:string" />
		<param name="type" as="xs:string" />
		<param name="getter-label-prefix" as="xs:string" />
		<param name="getter-name" as="xs:string" />
		<param name="non-final" as="xs:boolean*" />

	/**
	 * Default <value-of select="$getter-label-prefix" />getter for property <text />
	 	<value-of select="$name" />.
	 * 
	 * @return The <value-of select="$name" /> property
	 */
	public <text />
		<if test="not($non-final)">final </if>
		<value-of select="$type" />
		<text> </text>
		<value-of select="$getter-name" />() {
		return <value-of select="$name" />;
	}<text />
	</function>

	<function name="seaf:convert-name-to-sql" as="xs:string">
		<param name="name" as="xs:string" />
		<variable name="charA" select="string-to-codepoints('A')[1]" />
		<variable name="charZ" select="string-to-codepoints('Z')[1]" />
		<variable name="first-lower-name" 
			select="concat(lower-case(substring($name,1,1)),substring($name,2))" />
		<variable name="sequence" 
			select="for $char in string-to-codepoints($first-lower-name) return 
			if (($char >= $charA) and ($char &lt;= $charZ)) 
			then concat('_',codepoints-to-string($char))
			else codepoints-to-string($char)" />
		<value-of select="lower-case(string-join($sequence,''))" />
	</function>

	<function name="seaf:convert-name-to-label" as="xs:string">
		<param name="name" as="xs:string" />
		<variable name="charA" select="string-to-codepoints('A')[1]" />
		<variable name="charZ" select="string-to-codepoints('Z')[1]" />
		<variable name="first-lower-name" 
			select="concat(lower-case(substring($name,1,1)),substring($name,2))" />
		<variable name="sequence" 
			select="for $char in string-to-codepoints($first-lower-name) return 
			if (($char >= $charA) and ($char &lt;= $charZ)) 
			then concat(' ',codepoints-to-string($char))
			else codepoints-to-string($char)" />
		<value-of select="seaf:first-upper(lower-case(string-join($sequence,'')))" />
	</function>

	<!-- Operator field suffix -->
	<variable name="operator-field-suffix" select="'_Op'" />

	<!-- Convert a name of a field to the name of its corresponding operator field -->
	<function name="seaf:operator-field-name" as="xs:string">
		<param name="field-name" as="xs:string" />
		<value-of select="concat($field-name,$operator-field-suffix)" />
	</function>

	<!-- Generate getter and setter delegating to another property -->
	<function name="seaf:delegate-getter-setter" as="xs:string">
		<param name="name" as="xs:string" />
		<param name="type" as="xs:string" />
		<param name="as-property" as="xs:string" />
		<variable name="result">

	/**
	 * Return <value-of select="$name"/> delegating to <value-of select="$as-property"/>.
	 * 
	 * @return The <value-of select="$name"/> (<value-of select="$as-property"/> property)
	 */
	public <value-of select="$type"/><text> </text>
		<value-of select="seaf:getter-name($name)"/>() {
		return <value-of select="seaf:getter-name($as-property)"/>();
	}

	/**
	 * Set <value-of select="$name"/> delegating to <value-of select="$as-property"/>.
	 * 
	 * @param code
	 *            New value for <value-of select="$name"/> (<value-of select="$as-property"/> property)
	 */
	public void <value-of select="seaf:setter-name($name)"/>(<value-of select="$type"/>
		<text> </text><value-of select="$name"/>) {
		<value-of select="seaf:setter-name($as-property)"/>(<value-of select="$name"/>);
	}<text />
		</variable>
		<value-of select="$result" />
	</function>

</stylesheet>
