/*
 * Decompiled with CFR 0.152.
 */
package net.sf.seaf.mojo.util;

import java.io.File;
import java.util.HashMap;
import net.sf.seaf.mojo.util.GeneratorBase;
import net.sf.xsltmp.FromManyBase;
import net.sf.xsltmp.ManyToDynamicMojo;
import net.sf.xsltmp.ManyToManyMojo;
import net.sf.xsltmp.ManyToOneMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

public class WebGenerator
extends GeneratorBase {
    private final String webSrcIncludes;
    private final File mergedWebFile;
    private final File generatedXmlDir;
    private final File generatedJavaDir;

    public WebGenerator(MavenProject project, ArchiverManager archiverManager, Log log, File configurationDir, String sourceEncoding, String webSrcIncludes, File mergedWebFile, File generatedXmlDir, File generatedJavaDir) {
        super(project, archiverManager, log, configurationDir, sourceEncoding);
        this.webSrcIncludes = webSrcIncludes;
        this.mergedWebFile = mergedWebFile;
        this.generatedXmlDir = generatedXmlDir;
        this.generatedJavaDir = generatedJavaDir;
    }

    public void regenerateWeb() throws MojoExecutionException, MojoFailureException {
        this.mergeWeb();
        this.generateWebApplicationProperties();
        this.generateWebBeanConfig();
        this.generateWebEnumJava();
        this.generateWebPanelJava();
        this.generateWebPanelHtml();
        this.generateWebController();
        this.generateWebModel();
        this.generateWebDataProvider();
        this.generateWebFormJava();
        this.generateWebFormHtml();
        this.generateWebDataViewJava();
        this.generateWebListJava();
        this.generateWebListHtml();
        this.generateWebPageJava();
        this.generateWebPageHtml();
    }

    private void mergeWeb() throws MojoExecutionException, MojoFailureException {
        ManyToOneMojo mojo = new ManyToOneMojo();
        this.initMojoBaseProperties((FromManyBase)mojo);
        mojo.setSrcIncludes(this.webSrcIncludes);
        mojo.setXslTemplate("generator/seaf-commons/Merge.xsl");
        mojo.setDestFile(this.mergedWebFile);
        mojo.setForce(true);
        mojo.execute();
    }

    private void generateWebApplicationProperties() throws MojoExecutionException, MojoFailureException {
        ManyToOneMojo mojo = new ManyToOneMojo();
        this.initWebMojo((FromManyBase)mojo, "ApplicationProperties");
        mojo.setSrcFile(this.mergedWebFile);
        mojo.setDestFile(new File(this.generatedJavaDir, "net/sf/seaf/web/core/SeafApplication.properties"));
        mojo.execute();
    }

    private void generateWebBeanConfig() throws MojoExecutionException, MojoFailureException {
        ManyToManyMojo mojo = new ManyToManyMojo();
        this.initWebMojo((FromManyBase)mojo, "Beans");
        mojo.setDestDir(this.generatedXmlDir);
        mojo.setFileNameRegex("\\.xml");
        mojo.setFileNameReplacement("-beans\\.xml");
        HashMap<String, File> parameters = new HashMap<String, File>();
        parameters.put("merged-file-name", this.mergedWebFile);
        mojo.setParameters(parameters);
        mojo.execute();
    }

    private void generateWebEnumJava() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initWebMojo((FromManyBase)mojo, "EnumJava");
        mojo.setDestDir(this.generatedJavaDir);
        mojo.execute();
    }

    private void generateWebPanelJava() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initWebMojo((FromManyBase)mojo, "PanelJava");
        mojo.setDestDir(this.generatedJavaDir);
        HashMap<String, File> parameters = new HashMap<String, File>();
        parameters.put("merged-file-name", this.mergedWebFile);
        mojo.setParameters(parameters);
        mojo.execute();
    }

    private void generateWebPanelHtml() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initWebMojo((FromManyBase)mojo, "PanelHtml");
        mojo.setDestDir(this.generatedJavaDir);
        HashMap<String, File> parameters = new HashMap<String, File>();
        parameters.put("merged-file-name", this.mergedWebFile);
        mojo.setParameters(parameters);
        mojo.execute();
    }

    private void generateWebController() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initWebMojo((FromManyBase)mojo, "Controller");
        mojo.setDestDir(this.generatedJavaDir);
        HashMap<String, File> parameters = new HashMap<String, File>();
        parameters.put("merged-file-name", this.mergedWebFile);
        mojo.setParameters(parameters);
        mojo.execute();
    }

    private void generateWebModel() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initWebMojo((FromManyBase)mojo, "Model");
        mojo.setDestDir(this.generatedJavaDir);
        mojo.execute();
    }

    private void generateWebDataProvider() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initWebMojo((FromManyBase)mojo, "DataProvider");
        mojo.setDestDir(this.generatedJavaDir);
        mojo.execute();
    }

    private void generateWebFormJava() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initWebMojo((FromManyBase)mojo, "FormJava");
        mojo.setDestDir(this.generatedJavaDir);
        HashMap<String, File> parameters = new HashMap<String, File>();
        parameters.put("merged-file-name", this.mergedWebFile);
        mojo.setParameters(parameters);
        mojo.execute();
    }

    private void generateWebFormHtml() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initWebMojo((FromManyBase)mojo, "FormHtml");
        mojo.setDestDir(this.generatedJavaDir);
        mojo.execute();
    }

    private void generateWebDataViewJava() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initWebMojo((FromManyBase)mojo, "DataViewJava");
        mojo.setDestDir(this.generatedJavaDir);
        HashMap<String, File> parameters = new HashMap<String, File>();
        parameters.put("merged-file-name", this.mergedWebFile);
        mojo.setParameters(parameters);
        mojo.execute();
    }

    private void generateWebListJava() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initWebMojo((FromManyBase)mojo, "ListJava");
        mojo.setDestDir(this.generatedJavaDir);
        HashMap<String, File> parameters = new HashMap<String, File>();
        parameters.put("merged-file-name", this.mergedWebFile);
        mojo.setParameters(parameters);
        mojo.execute();
    }

    private void generateWebListHtml() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initWebMojo((FromManyBase)mojo, "ListHtml");
        mojo.setDestDir(this.generatedJavaDir);
        HashMap<String, File> parameters = new HashMap<String, File>();
        parameters.put("merged-file-name", this.mergedWebFile);
        mojo.setParameters(parameters);
        mojo.execute();
    }

    private void generateWebPageJava() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initWebMojo((FromManyBase)mojo, "PageJava");
        mojo.setDestDir(this.generatedJavaDir);
        HashMap<String, File> parameters = new HashMap<String, File>();
        parameters.put("merged-file-name", this.mergedWebFile);
        mojo.setParameters(parameters);
        mojo.execute();
    }

    private void generateWebPageHtml() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initWebMojo((FromManyBase)mojo, "PageHtml");
        mojo.setDestDir(this.generatedJavaDir);
        mojo.execute();
    }

    private void initWebMojo(FromManyBase mojo, String template) {
        this.initMojoBaseProperties(mojo);
        mojo.setSrcIncludes(this.webSrcIncludes);
        mojo.setXslTemplate("generator/seaf-web/" + template + ".xsl");
    }
}

