/*
 * Decompiled with CFR 0.152.
 */
package net.sf.seaf.mojo.util;

import java.io.File;
import java.util.HashMap;
import net.sf.seaf.mojo.util.GeneratorBase;
import net.sf.xsltmp.FromManyBase;
import net.sf.xsltmp.ManyToDynamicMojo;
import net.sf.xsltmp.ManyToManyMojo;
import net.sf.xsltmp.ManyToOneMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

public class ServiceGenerator
extends GeneratorBase {
    private final String serviceSrcIncludes;
    private final File mergedServiceFile;
    private final File serviceReportDir;
    private final String applicationName;
    private final String applicationVersion;
    private final String mergedPersistenceFile;
    private final File generatedXmlDir;
    private final File generatedJavaDir;

    public ServiceGenerator(MavenProject project, ArchiverManager archiverManager, Log log, File configurationDir, String sourceEncoding, String serviceSrcIncludes, File mergedServiceFile, File serviceReportDir, String applicationName, String applicationVersion, String mergedPersistenceFile, File generatedXmlDir, File generatedJavaDir) {
        super(project, archiverManager, log, configurationDir, sourceEncoding);
        this.serviceSrcIncludes = serviceSrcIncludes;
        this.mergedServiceFile = mergedServiceFile;
        this.serviceReportDir = serviceReportDir;
        this.applicationName = applicationName;
        this.applicationVersion = applicationVersion;
        this.mergedPersistenceFile = mergedPersistenceFile;
        this.generatedXmlDir = generatedXmlDir;
        this.generatedJavaDir = generatedJavaDir;
    }

    public void regenerateService() throws MojoExecutionException, MojoFailureException {
        this.mergeService();
        this.generateServiceReport();
        this.generateServiceEnums();
        this.generateServiceBeans();
        this.generateServiceInterface();
        this.generateServiceFactory();
        this.generateServiceControllerInterface();
    }

    private void mergeService() throws MojoExecutionException, MojoFailureException {
        ManyToOneMojo mojo = new ManyToOneMojo();
        this.initMojoBaseProperties((FromManyBase)mojo);
        mojo.setSrcIncludes(this.serviceSrcIncludes);
        mojo.setXslTemplate("generator/seaf-commons/Merge.xsl");
        mojo.setDestFile(this.mergedServiceFile);
        mojo.setForce(true);
        mojo.execute();
    }

    private void generateServiceReport() throws MojoExecutionException, MojoFailureException {
        ManyToOneMojo mojo = new ManyToOneMojo();
        this.initServiceMojo((FromManyBase)mojo, "Report");
        mojo.setSrcFile(this.mergedServiceFile);
        mojo.setDestFile(new File(this.serviceReportDir, "service-report.html"));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("application-name", this.applicationName);
        parameters.put("version", this.applicationVersion);
        parameters.put("persistence-merged-file-name", this.mergedPersistenceFile);
        mojo.setParameters(parameters);
        mojo.execute();
    }

    private void generateServiceEnums() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initServiceMojo((FromManyBase)mojo, "Enum");
        mojo.setDestDir(this.generatedJavaDir);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("persistence-merged-file-name", this.mergedPersistenceFile);
        mojo.setParameters(parameters);
        mojo.execute();
    }

    private void generateServiceBeans() throws MojoExecutionException, MojoFailureException {
        ManyToManyMojo mojo = new ManyToManyMojo();
        this.initServiceMojo((FromManyBase)mojo, "Beans");
        mojo.setDestDir(this.generatedXmlDir);
        mojo.setFileNameRegex("\\.xml");
        mojo.setFileNameReplacement("-beans\\.xml");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("persistence-merged-file-name", this.mergedPersistenceFile);
        parameters.put("service-merged-file-name", this.mergedServiceFile);
        mojo.setParameters(parameters);
        mojo.execute();
    }

    private void generateServiceInterface() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initServiceMojo((FromManyBase)mojo, "ServiceInterface");
        mojo.setDestDir(this.generatedJavaDir);
        HashMap<String, File> parameters = new HashMap<String, File>();
        parameters.put("service-merged-file-name", this.mergedServiceFile);
        mojo.setParameters(parameters);
        mojo.execute();
    }

    private void generateServiceFactory() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initServiceMojo((FromManyBase)mojo, "ServiceFactory");
        mojo.setDestDir(this.generatedJavaDir);
        HashMap<String, File> parameters = new HashMap<String, File>();
        parameters.put("service-merged-file-name", this.mergedServiceFile);
        mojo.setParameters(parameters);
        mojo.execute();
    }

    private void generateServiceControllerInterface() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initServiceMojo((FromManyBase)mojo, "ControllerInterface");
        mojo.setDestDir(this.generatedJavaDir);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("persistence-merged-file-name", this.mergedPersistenceFile);
        parameters.put("service-merged-file-name", this.mergedServiceFile);
        mojo.setParameters(parameters);
        mojo.execute();
    }

    private void initServiceMojo(FromManyBase mojo, String template) {
        this.initMojoBaseProperties(mojo);
        mojo.setSrcIncludes(this.serviceSrcIncludes);
        mojo.setXslTemplate("generator/seaf-service/" + template + ".xsl");
    }
}

