/*
 * Decompiled with CFR 0.152.
 */
package net.sf.seaf.mojo.util;

import java.io.File;
import java.util.HashMap;
import net.sf.seaf.mojo.util.GeneratorBase;
import net.sf.xsltmp.FromManyBase;
import net.sf.xsltmp.ManyToDynamicMojo;
import net.sf.xsltmp.ManyToManyMojo;
import net.sf.xsltmp.ManyToOneMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

public class PersistenceGenerator
extends GeneratorBase {
    private final String persistenceSrcIncludes;
    private final File mergedPersistenceFile;
    private final File persistenceReportDir;
    private final String applicationName;
    private final String applicationVersion;
    private final File generatedXmlDir;
    private final File generatedJavaDir;
    private final File enumInitFile;
    private final File persistenceContextFile;
    private final File hibernateCfgXmlSrcFile;
    private final File hibernateCfgXmlDestFile;
    private final File sessionFactoryContextSrcFile;
    private final File sessionFactoryContextDestFile;
    private final File codeTableInitSrcFile;
    private final File codeTableInitDestFile;
    private final String generatePersistenceMode;

    public PersistenceGenerator(MavenProject project, ArchiverManager archiverManager, Log log, File configurationDir, String sourceEncoding, String persistenceSrcIncludes, File mergedPersistenceFile, File persistenceReportDir, String applicationName, String applicationVersion, File generatedXmlDir, File generatedJavaDir, File enumInitFile, File persistenceContextFile, File hibernateCfgXmlSrcFile, File hibernateCfgXmlDestFile, File sessionFactoryContextSrcFile, File sessionFactoryContextDestFile, File codeTableInitSrcFile, File codeTableInitDestFile, String generatePersistenceMode) {
        super(project, archiverManager, log, configurationDir, sourceEncoding);
        this.persistenceSrcIncludes = persistenceSrcIncludes;
        this.mergedPersistenceFile = mergedPersistenceFile;
        this.persistenceReportDir = persistenceReportDir;
        this.applicationName = applicationName;
        this.applicationVersion = applicationVersion;
        this.generatedXmlDir = generatedXmlDir;
        this.generatedJavaDir = generatedJavaDir;
        this.enumInitFile = enumInitFile;
        this.persistenceContextFile = persistenceContextFile;
        this.hibernateCfgXmlSrcFile = hibernateCfgXmlSrcFile;
        this.hibernateCfgXmlDestFile = hibernateCfgXmlDestFile;
        this.sessionFactoryContextSrcFile = sessionFactoryContextSrcFile;
        this.sessionFactoryContextDestFile = sessionFactoryContextDestFile;
        this.codeTableInitSrcFile = codeTableInitSrcFile;
        this.codeTableInitDestFile = codeTableInitDestFile;
        this.generatePersistenceMode = generatePersistenceMode;
    }

    public void regeneratePersistence() throws MojoExecutionException, MojoFailureException {
        this.mergePersistence();
        this.generatePersistenceReport();
        this.generatePersistenceBeanConfig();
        this.generatePersistenceEnumJava();
        if (this.isFull()) {
            this.generatePersistenceEnumHbmXml();
            this.generatePersistenceEnumSql();
            this.generatePersistenceDao();
            this.generatePersistenceHibernateDao();
            this.generatePersistenceControllerBase();
            this.generatePersistenceController();
            this.generatePersistenceControllerImplBase();
            this.generatePersistenceControllerImpl();
            this.generatePersistenceHbmXml();
            this.generatePersistenceContext();
        }
    }

    private void mergePersistence() throws MojoExecutionException, MojoFailureException {
        ManyToOneMojo mojo = new ManyToOneMojo();
        this.initMojoBaseProperties((FromManyBase)mojo);
        mojo.setSrcIncludes(this.persistenceSrcIncludes);
        mojo.setXslTemplate("generator/seaf-commons/Merge.xsl");
        mojo.setDestFile(this.mergedPersistenceFile);
        mojo.setForce(true);
        mojo.execute();
    }

    private void generatePersistenceReport() throws MojoExecutionException, MojoFailureException {
        ManyToOneMojo mojo = new ManyToOneMojo();
        this.initPersistenceMojo((FromManyBase)mojo, "Report");
        mojo.setSrcFile(this.mergedPersistenceFile);
        mojo.setDestFile(new File(this.persistenceReportDir, "persistence-report.html"));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("application-name", this.applicationName);
        parameters.put("version", this.applicationVersion);
        mojo.setParameters(parameters);
        mojo.execute();
    }

    private void generatePersistenceBeanConfig() throws MojoExecutionException, MojoFailureException {
        ManyToManyMojo mojo = new ManyToManyMojo();
        this.initPersistenceMojo((FromManyBase)mojo, "Beans");
        mojo.setDestDir(this.generatedXmlDir);
        mojo.setFileNameRegex("\\.xml");
        mojo.setFileNameReplacement("-beans\\.xml");
        HashMap<String, File> parameters = new HashMap<String, File>();
        parameters.put("merged-file-name", this.mergedPersistenceFile);
        mojo.setParameters(parameters);
        mojo.execute();
    }

    private void generatePersistenceEnumJava() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initPersistenceMojo((FromManyBase)mojo, "EnumJava");
        mojo.setDestDir(this.generatedJavaDir);
        mojo.execute();
    }

    private void generatePersistenceEnumHbmXml() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initPersistenceMojo((FromManyBase)mojo, "EnumHbmXml");
        mojo.setDestDir(this.generatedJavaDir);
        mojo.execute();
    }

    private void generatePersistenceEnumSql() throws MojoExecutionException, MojoFailureException {
        ManyToOneMojo mojo = new ManyToOneMojo();
        this.initPersistenceMojo((FromManyBase)mojo, "EnumSql");
        mojo.setDestFile(this.enumInitFile);
        HashMap<String, File> parameters = new HashMap<String, File>();
        parameters.put("merged-file-name", this.mergedPersistenceFile);
        mojo.setParameters(parameters);
        mojo.execute();
    }

    private void generatePersistenceDao() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initPersistenceMojo((FromManyBase)mojo, "DAO");
        mojo.setDestDir(this.generatedJavaDir);
        mojo.execute();
    }

    private void generatePersistenceHibernateDao() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initPersistenceMojo((FromManyBase)mojo, "HibernateDAO");
        mojo.setDestDir(this.generatedJavaDir);
        mojo.execute();
    }

    private void generatePersistenceControllerBase() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initPersistenceMojo((FromManyBase)mojo, "ControllerBase");
        mojo.setDestDir(this.generatedJavaDir);
        mojo.execute();
    }

    private void generatePersistenceController() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initPersistenceMojo((FromManyBase)mojo, "Controller");
        mojo.setDestDir(this.generatedJavaDir);
        mojo.execute();
    }

    private void generatePersistenceControllerImplBase() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initPersistenceMojo((FromManyBase)mojo, "ControllerImplBase");
        mojo.setDestDir(this.generatedJavaDir);
        mojo.execute();
    }

    private void generatePersistenceControllerImpl() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initPersistenceMojo((FromManyBase)mojo, "ControllerImpl");
        mojo.setDestDir(this.generatedJavaDir);
        mojo.execute();
    }

    private void generatePersistenceHbmXml() throws MojoExecutionException, MojoFailureException {
        ManyToDynamicMojo mojo = new ManyToDynamicMojo();
        this.initPersistenceMojo((FromManyBase)mojo, "HbmXml");
        mojo.setDestDir(this.generatedJavaDir);
        HashMap<String, File> parameters = new HashMap<String, File>();
        parameters.put("merged-file-name", this.mergedPersistenceFile);
        mojo.setParameters(parameters);
        mojo.execute();
    }

    private void generatePersistenceContext() throws MojoExecutionException, MojoFailureException {
        ManyToOneMojo mojo = new ManyToOneMojo();
        this.initPersistenceMojo((FromManyBase)mojo, "PersistenceContext");
        mojo.setDestFile(this.persistenceContextFile);
        HashMap<String, File> parameters = new HashMap<String, File>();
        parameters.put("merged-file-name", this.mergedPersistenceFile);
        mojo.setParameters(parameters);
        mojo.execute();
    }

    public void generatePersistenceHibernateCfg() throws MojoExecutionException, MojoFailureException {
        ManyToOneMojo mojo = new ManyToOneMojo();
        this.initPersistenceMojo((FromManyBase)mojo, "HibernateCfg");
        mojo.setSrcFile(this.hibernateCfgXmlSrcFile);
        mojo.setDestFile(this.hibernateCfgXmlDestFile);
        HashMap<String, File> parameters = new HashMap<String, File>();
        parameters.put("merged-file-name", this.mergedPersistenceFile);
        mojo.setParameters(parameters);
        mojo.execute();
    }

    public void generatePersistenceSessionFactoryContext() throws MojoExecutionException, MojoFailureException {
        ManyToOneMojo mojo = new ManyToOneMojo();
        this.initPersistenceMojo((FromManyBase)mojo, "SessionFactoryContext");
        mojo.setSrcFile(this.sessionFactoryContextSrcFile);
        mojo.setDestFile(this.sessionFactoryContextDestFile);
        HashMap<String, File> parameters = new HashMap<String, File>();
        parameters.put("merged-file-name", this.mergedPersistenceFile);
        mojo.setParameters(parameters);
        mojo.execute();
    }

    public void generatePersistenceCodeTableInit() throws MojoExecutionException, MojoFailureException {
        ManyToOneMojo mojo = new ManyToOneMojo();
        this.initPersistenceMojo((FromManyBase)mojo, "XmlToSqlInserts");
        mojo.setSrcFile(this.codeTableInitSrcFile);
        mojo.setDestFile(this.codeTableInitDestFile);
        mojo.execute();
    }

    private void initPersistenceMojo(FromManyBase mojo, String template) {
        this.initMojoBaseProperties(mojo);
        mojo.setSrcIncludes(this.persistenceSrcIncludes);
        mojo.setXslTemplate("generator/seaf-persistence/" + template + ".xsl");
    }

    public boolean isFull() {
        return "full".equals(this.generatePersistenceMode);
    }
}

