/*
 * Decompiled with CFR 0.152.
 */
package net.sf.seaf.mojo.util;

import java.io.File;
import net.sf.jbg.mojo.BeansMojo;
import net.sf.xsltmp.FromManyBase;
import net.sf.xsltmp.util.EncodingUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

public class GeneratorBase {
    private final MavenProject project;
    private final ArchiverManager archiverManager;
    private final Log log;
    private final File configurationDir;
    private String sourceEncoding;
    private static final EncodingUtils ENCODING_UTILS = new EncodingUtils();

    public GeneratorBase(MavenProject project, ArchiverManager archiverManager, Log log, File configurationDir, String sourceEncoding) {
        this.project = project;
        this.archiverManager = archiverManager;
        this.log = log;
        this.configurationDir = configurationDir;
        this.sourceEncoding = sourceEncoding;
    }

    protected void initMojoBaseProperties(FromManyBase mojo) {
        mojo.setProject(this.project);
        mojo.setArchiverManager(this.archiverManager);
        mojo.setLog(this.log);
        mojo.setSrcDir(this.configurationDir);
        mojo.setSourceEncoding(this.getSourceEncoding());
    }

    protected void initMojoBaseProperties(BeansMojo mojo) {
        mojo.setProject(this.project);
        mojo.setArchiverManager(this.archiverManager);
        mojo.setLog(this.log);
        mojo.setSourceEncoding(this.getSourceEncoding());
    }

    public String getSourceEncoding() {
        this.sourceEncoding = ENCODING_UTILS.defaultByPlatformEncoding(this.sourceEncoding, this.log);
        return this.sourceEncoding;
    }
}

