/*
 * Decompiled with CFR 0.152.
 */
package net.sf.seaf.mojo;

import java.io.File;
import net.sf.seaf.mojo.util.BeansGenerator;
import net.sf.seaf.mojo.util.FilesChangedUtils;
import net.sf.seaf.mojo.util.PersistenceGenerator;
import net.sf.seaf.mojo.util.ServiceGenerator;
import net.sf.seaf.mojo.util.WebGenerator;
import net.sf.xsltmp.FinalizeMojo;
import net.sf.xsltmp.InitializeMojo;
import net.sf.xsltmp.util.AddSourcesUtils;
import net.sf.xsltmp.util.TimestampUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

public class GenerateAllMojo
extends AbstractMojo {
    private boolean generatePersistence;
    private boolean generateService;
    private boolean generateWeb;
    private String persistenceSrcIncludes;
    private String serviceSrcIncludes;
    private String webSrcIncludes;
    private File configurationDir;
    private String sourceEncoding;
    private File persistenceReportDir;
    private File serviceReportDir;
    private String applicationName;
    private String applicationVersion;
    private File enumInitFile;
    private File hibernateCfgXmlSrcFile;
    private File hibernateCfgXmlDestFile;
    private File sessionFactoryContextSrcFile;
    private File sessionFactoryContextDestFile;
    private File persistenceContextFile;
    private File codeTableInitSrcFile;
    private File codeTableInitDestFile;
    private String generatePersistenceMode;
    private String mergedPersistenceFile;
    private File mergedServiceFile;
    private File mergedWebFile;
    private File generatedXmlDir;
    private File generatedJavaDir;
    private String addGeneratedSourcesTo;
    private String addGeneratedResourcesTo;
    private MavenProject project;
    private ArchiverManager archiverManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean beansChanged;
        TimestampUtils timestampUtils = new TimestampUtils(this.project);
        FilesChangedUtils filesChangedUtils = new FilesChangedUtils();
        File timestampFile = timestampUtils.getTimestampFile();
        if (!(this.generatePersistence || this.generateWeb || this.generateService)) {
            this.getLog().warn((CharSequence)"No layer set for generation. (Did you forget to set one?)");
            return;
        }
        AddSourcesUtils addSourcesUtils = new AddSourcesUtils(this.project, this.getLog());
        addSourcesUtils.addSources(this.addGeneratedSourcesTo, this.generatedJavaDir);
        addSourcesUtils.addResources(this.addGeneratedResourcesTo, this.generatedJavaDir);
        boolean persistenceChanged = false;
        boolean hibernateCfgChanged = false;
        boolean sessionFactoryContextChanged = false;
        boolean codeTableInitChanged = false;
        boolean serviceChanged = false;
        boolean webChanged = false;
        if (this.generatePersistence) {
            if (filesChangedUtils.filesChanged(this.configurationDir, this.persistenceSrcIncludes, timestampFile)) {
                persistenceChanged = true;
                hibernateCfgChanged = true;
                sessionFactoryContextChanged = true;
            }
            if (!hibernateCfgChanged && this.hibernateCfgXmlSrcFile.exists() && this.hibernateCfgXmlSrcFile.lastModified() > timestampFile.lastModified()) {
                hibernateCfgChanged = true;
            }
            if (!sessionFactoryContextChanged && this.sessionFactoryContextSrcFile.exists() && this.sessionFactoryContextSrcFile.lastModified() > timestampFile.lastModified()) {
                sessionFactoryContextChanged = true;
            }
            if (this.codeTableInitSrcFile.exists() && this.codeTableInitSrcFile.lastModified() > timestampFile.lastModified()) {
                codeTableInitChanged = true;
            }
        }
        if (this.generateService && filesChangedUtils.filesChanged(this.configurationDir, this.serviceSrcIncludes, timestampFile)) {
            serviceChanged = true;
        }
        if (this.generateWeb && filesChangedUtils.filesChanged(this.configurationDir, this.webSrcIncludes, timestampFile)) {
            webChanged = true;
        }
        boolean changed = persistenceChanged || hibernateCfgChanged || sessionFactoryContextChanged || codeTableInitChanged || serviceChanged || webChanged;
        boolean bl = beansChanged = persistenceChanged || serviceChanged || webChanged;
        if (changed) {
            this.initialize();
        }
        PersistenceGenerator persistenceGenerator = this.createPersistenceGenerator();
        if (persistenceChanged) {
            this.getLog().info((CharSequence)("Regenerating persistence layer from configuration in mode " + this.generatePersistenceMode + "..."));
            persistenceGenerator.regeneratePersistence();
        }
        if (hibernateCfgChanged && persistenceGenerator.isFull()) {
            this.getLog().info((CharSequence)"Regenerating hibernate.cfg.xml file...");
            persistenceGenerator.generatePersistenceHibernateCfg();
        }
        if (sessionFactoryContextChanged && persistenceGenerator.isFull()) {
            this.getLog().info((CharSequence)"Regenerating session factory context file...");
            persistenceGenerator.generatePersistenceSessionFactoryContext();
        }
        if (codeTableInitChanged && persistenceGenerator.isFull()) {
            this.getLog().info((CharSequence)"Regenerating code table init file...");
            persistenceGenerator.generatePersistenceCodeTableInit();
        }
        if (serviceChanged) {
            this.getLog().info((CharSequence)"Regenerating service layer from configuration...");
            ServiceGenerator serviceGenerator = this.createServiceGenerator();
            serviceGenerator.regenerateService();
        }
        if (webChanged) {
            this.getLog().info((CharSequence)"Regenerating web layer from configuration...");
            WebGenerator webGenerator = this.createWebGenerator();
            webGenerator.regenerateWeb();
        }
        if (beansChanged) {
            this.getLog().info((CharSequence)"Regenerating beans...");
            BeansGenerator beansGenerator = this.createBeansGenerator();
            beansGenerator.generateBeans();
        }
        if (changed) {
            this.finalize_();
        }
        if (!changed) {
            this.getLog().info((CharSequence)"Up to date.");
        }
    }

    private void initialize() throws MojoExecutionException, MojoFailureException {
        InitializeMojo mojo = new InitializeMojo();
        mojo.setProject(this.project);
        mojo.setLog(this.getLog());
        mojo.execute();
    }

    private void finalize_() throws MojoExecutionException, MojoFailureException {
        FinalizeMojo mojo = new FinalizeMojo();
        mojo.setProject(this.project);
        mojo.setLog(this.getLog());
        mojo.execute();
    }

    private BeansGenerator createBeansGenerator() {
        return new BeansGenerator(this.project, this.archiverManager, this.getLog(), this.configurationDir, this.sourceEncoding, this.generatedXmlDir, this.generatedJavaDir);
    }

    private WebGenerator createWebGenerator() {
        return new WebGenerator(this.project, this.archiverManager, this.getLog(), this.configurationDir, this.sourceEncoding, this.webSrcIncludes, this.mergedWebFile, this.generatedXmlDir, this.generatedJavaDir);
    }

    private ServiceGenerator createServiceGenerator() {
        return new ServiceGenerator(this.project, this.archiverManager, this.getLog(), this.configurationDir, this.sourceEncoding, this.serviceSrcIncludes, this.mergedServiceFile, this.serviceReportDir, this.applicationName, this.applicationVersion, this.mergedPersistenceFile, this.generatedXmlDir, this.generatedJavaDir);
    }

    private PersistenceGenerator createPersistenceGenerator() {
        return new PersistenceGenerator(this.project, this.archiverManager, this.getLog(), this.configurationDir, this.sourceEncoding, this.persistenceSrcIncludes, new File(this.mergedPersistenceFile), this.persistenceReportDir, this.applicationName, this.applicationVersion, this.generatedXmlDir, this.generatedJavaDir, this.enumInitFile, this.persistenceContextFile, this.hibernateCfgXmlSrcFile, this.hibernateCfgXmlDestFile, this.sessionFactoryContextSrcFile, this.sessionFactoryContextDestFile, this.codeTableInitSrcFile, this.codeTableInitDestFile, this.generatePersistenceMode);
    }
}

