package net.sf.seaf.mojo.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import net.sf.xsltmp.FromManyBase;
import net.sf.xsltmp.ManyToDynamicMojo;
import net.sf.xsltmp.ManyToManyMojo;
import net.sf.xsltmp.ManyToOneMojo;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

public class WebGenerator extends GeneratorBase {

	private final String webSrcIncludes;
	private final File mergedWebFile;
	private final File generatedXmlDir;
	private final File generatedJavaDir;

	public WebGenerator(MavenProject project, ArchiverManager archiverManager,
			Log log, File configurationDir, String sourceEncoding,
			String webSrcIncludes, File mergedWebFile, File generatedXmlDir,
			File generatedJavaDir) {
		super(project, archiverManager, log, configurationDir, sourceEncoding);
		this.webSrcIncludes = webSrcIncludes;
		this.mergedWebFile = mergedWebFile;
		this.generatedXmlDir = generatedXmlDir;
		this.generatedJavaDir = generatedJavaDir;
	}

	public void regenerateWeb() throws MojoExecutionException,
			MojoFailureException {
		mergeWeb();
		generateWebApplicationProperties();
		generateWebBeanConfig();
		generateWebEnumJava();
		generateWebPanelJava();
		generateWebPanelHtml();
		generateWebController();
		generateWebModel();
		generateWebDataProvider();
		generateWebFormJava();
		generateWebFormHtml();
		generateWebDataViewJava();
		generateWebListJava();
		generateWebListHtml();
		generateWebPageJava();
		generateWebPageHtml();
	}

	private void mergeWeb() throws MojoExecutionException, MojoFailureException {
		ManyToOneMojo mojo = new ManyToOneMojo();
		initMojoBaseProperties(mojo);
		mojo.setSrcIncludes(webSrcIncludes);
		mojo.setXslTemplate("generator/seaf-commons/Merge.xsl");
		mojo.setDestFile(mergedWebFile);
		mojo.setForce(true);
		mojo.execute();
	}

	private void generateWebApplicationProperties()
			throws MojoExecutionException, MojoFailureException {
		ManyToOneMojo mojo = new ManyToOneMojo();
		initWebMojo(mojo, "ApplicationProperties");
		mojo.setSrcFile(mergedWebFile);
		mojo.setDestFile(new File(generatedJavaDir,
				"net/sf/seaf/web/core/SeafApplication.properties"));
		mojo.execute();
	}

	private void generateWebBeanConfig() throws MojoExecutionException,
			MojoFailureException {
		ManyToManyMojo mojo = new ManyToManyMojo();
		initWebMojo(mojo, "Beans");
		mojo.setDestDir(generatedXmlDir);
		mojo.setFileNameRegex("\\.xml");
		mojo.setFileNameReplacement("-beans\\.xml");
		Map parameters = new HashMap();
		parameters.put("merged-file-name", mergedWebFile);
		mojo.setParameters(parameters);
		mojo.execute();
	}

	private void generateWebEnumJava() throws MojoExecutionException,
			MojoFailureException {
		ManyToDynamicMojo mojo = new ManyToDynamicMojo();
		initWebMojo(mojo, "EnumJava");
		mojo.setDestDir(generatedJavaDir);
		mojo.execute();
	}

	private void generateWebPanelJava() throws MojoExecutionException,
			MojoFailureException {
		ManyToDynamicMojo mojo = new ManyToDynamicMojo();
		initWebMojo(mojo, "PanelJava");
		mojo.setDestDir(generatedJavaDir);
		Map parameters = new HashMap();
		parameters.put("merged-file-name", mergedWebFile);
		mojo.setParameters(parameters);
		mojo.execute();
	}

	private void generateWebPanelHtml() throws MojoExecutionException,
			MojoFailureException {
		ManyToDynamicMojo mojo = new ManyToDynamicMojo();
		initWebMojo(mojo, "PanelHtml");
		mojo.setDestDir(generatedJavaDir);
		Map parameters = new HashMap();
		parameters.put("merged-file-name", mergedWebFile);
		mojo.setParameters(parameters);
		mojo.execute();
	}

	private void generateWebController() throws MojoExecutionException,
			MojoFailureException {
		ManyToDynamicMojo mojo = new ManyToDynamicMojo();
		initWebMojo(mojo, "Controller");
		mojo.setDestDir(generatedJavaDir);
		Map parameters = new HashMap();
		parameters.put("merged-file-name", mergedWebFile);
		mojo.setParameters(parameters);
		mojo.execute();
	}

	private void generateWebModel() throws MojoExecutionException,
			MojoFailureException {
		ManyToDynamicMojo mojo = new ManyToDynamicMojo();
		initWebMojo(mojo, "Model");
		mojo.setDestDir(generatedJavaDir);
		mojo.execute();
	}

	private void generateWebDataProvider() throws MojoExecutionException,
			MojoFailureException {
		ManyToDynamicMojo mojo = new ManyToDynamicMojo();
		initWebMojo(mojo, "DataProvider");
		mojo.setDestDir(generatedJavaDir);
		mojo.execute();
	}

	private void generateWebFormJava() throws MojoExecutionException,
			MojoFailureException {
		ManyToDynamicMojo mojo = new ManyToDynamicMojo();
		initWebMojo(mojo, "FormJava");
		mojo.setDestDir(generatedJavaDir);
		Map parameters = new HashMap();
		parameters.put("merged-file-name", mergedWebFile);
		mojo.setParameters(parameters);
		mojo.execute();
	}

	private void generateWebFormHtml() throws MojoExecutionException,
			MojoFailureException {
		ManyToDynamicMojo mojo = new ManyToDynamicMojo();
		initWebMojo(mojo, "FormHtml");
		mojo.setDestDir(generatedJavaDir);
		mojo.execute();
	}

	private void generateWebDataViewJava() throws MojoExecutionException,
			MojoFailureException {
		ManyToDynamicMojo mojo = new ManyToDynamicMojo();
		initWebMojo(mojo, "DataViewJava");
		mojo.setDestDir(generatedJavaDir);
		Map parameters = new HashMap();
		parameters.put("merged-file-name", mergedWebFile);
		mojo.setParameters(parameters);
		mojo.execute();
	}

	private void generateWebListJava() throws MojoExecutionException,
			MojoFailureException {
		ManyToDynamicMojo mojo = new ManyToDynamicMojo();
		initWebMojo(mojo, "ListJava");
		mojo.setDestDir(generatedJavaDir);
		Map parameters = new HashMap();
		parameters.put("merged-file-name", mergedWebFile);
		mojo.setParameters(parameters);
		mojo.execute();
	}

	private void generateWebListHtml() throws MojoExecutionException,
			MojoFailureException {
		ManyToDynamicMojo mojo = new ManyToDynamicMojo();
		initWebMojo(mojo, "ListHtml");
		mojo.setDestDir(generatedJavaDir);
		Map parameters = new HashMap();
		parameters.put("merged-file-name", mergedWebFile);
		mojo.setParameters(parameters);
		mojo.execute();
	}

	private void generateWebPageJava() throws MojoExecutionException,
			MojoFailureException {
		ManyToDynamicMojo mojo = new ManyToDynamicMojo();
		initWebMojo(mojo, "PageJava");
		mojo.setDestDir(generatedJavaDir);
		Map parameters = new HashMap();
		parameters.put("merged-file-name", mergedWebFile);
		mojo.setParameters(parameters);
		mojo.execute();
	}

	private void generateWebPageHtml() throws MojoExecutionException,
			MojoFailureException {
		ManyToDynamicMojo mojo = new ManyToDynamicMojo();
		initWebMojo(mojo, "PageHtml");
		mojo.setDestDir(generatedJavaDir);
		mojo.execute();
	}

	private void initWebMojo(FromManyBase mojo, String template) {
		initMojoBaseProperties(mojo);
		mojo.setSrcIncludes(webSrcIncludes);
		mojo.setXslTemplate("generator/seaf-web/" + template + ".xsl");
	}

}
