package net.sf.seaf.mojo.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import net.sf.xsltmp.FromManyBase;
import net.sf.xsltmp.ManyToDynamicMojo;
import net.sf.xsltmp.ManyToManyMojo;
import net.sf.xsltmp.ManyToOneMojo;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

public class PersistenceGenerator extends GeneratorBase {

	private final String persistenceSrcIncludes;
	private final File mergedPersistenceFile;
	private final File persistenceReportDir;
	private final String applicationName;
	private final String applicationVersion;
	private final File generatedXmlDir;
	private final File generatedJavaDir;
	private final File enumInitFile;
	private final File persistenceContextFile;
	private final File hibernateCfgXmlSrcFile;
	private final File hibernateCfgXmlDestFile;
	private final File sessionFactoryContextSrcFile;
	private final File sessionFactoryContextDestFile;
	private final File codeTableInitSrcFile;
	private final File codeTableInitDestFile;
	private final String generatePersistenceMode;

	public PersistenceGenerator(MavenProject project,
			ArchiverManager archiverManager, Log log, File configurationDir,
			String sourceEncoding, String persistenceSrcIncludes,
			File mergedPersistenceFile, File persistenceReportDir,
			String applicationName, String applicationVersion,
			File generatedXmlDir, File generatedJavaDir, File enumInitFile,
			File persistenceContextFile, File hibernateCfgXmlSrcFile,
			File hibernateCfgXmlDestFile, File sessionFactoryContextSrcFile,
			File sessionFactoryContextDestFile, File codeTableInitSrcFile,
			File codeTableInitDestFile, String generatePersistenceMode) {
		super(project, archiverManager, log, configurationDir, sourceEncoding);
		this.persistenceSrcIncludes = persistenceSrcIncludes;
		this.mergedPersistenceFile = mergedPersistenceFile;
		this.persistenceReportDir = persistenceReportDir;
		this.applicationName = applicationName;
		this.applicationVersion = applicationVersion;
		this.generatedXmlDir = generatedXmlDir;
		this.generatedJavaDir = generatedJavaDir;
		this.enumInitFile = enumInitFile;
		this.persistenceContextFile = persistenceContextFile;
		this.hibernateCfgXmlSrcFile = hibernateCfgXmlSrcFile;
		this.hibernateCfgXmlDestFile = hibernateCfgXmlDestFile;
		this.sessionFactoryContextSrcFile = sessionFactoryContextSrcFile;
		this.sessionFactoryContextDestFile = sessionFactoryContextDestFile;
		this.codeTableInitSrcFile = codeTableInitSrcFile;
		this.codeTableInitDestFile = codeTableInitDestFile;
		this.generatePersistenceMode = generatePersistenceMode;
	}

	public void regeneratePersistence() throws MojoExecutionException,
			MojoFailureException {
		mergePersistence();
		generatePersistenceReport();
		generatePersistenceBeanConfig();
		generatePersistenceEnumJava();
		if (isFull()) {
			generatePersistenceEnumHbmXml();
			generatePersistenceEnumSql();
			generatePersistenceDao();
			generatePersistenceHibernateDao();
			generatePersistenceControllerBase();
			generatePersistenceController();
			generatePersistenceControllerImplBase();
			generatePersistenceControllerImpl();
			generatePersistenceHbmXml();
			generatePersistenceContext();
		}
	}

	private void mergePersistence() throws MojoExecutionException,
			MojoFailureException {
		ManyToOneMojo mojo = new ManyToOneMojo();
		initMojoBaseProperties(mojo);
		mojo.setSrcIncludes(persistenceSrcIncludes);
		mojo.setXslTemplate("generator/seaf-commons/Merge.xsl");
		mojo.setDestFile(mergedPersistenceFile);
		mojo.setForce(true);
		mojo.execute();
	}

	private void generatePersistenceReport() throws MojoExecutionException,
			MojoFailureException {
		ManyToOneMojo mojo = new ManyToOneMojo();
		initPersistenceMojo(mojo, "Report");
		mojo.setSrcFile(mergedPersistenceFile);
		mojo.setDestFile(new File(persistenceReportDir,
				"persistence-report.html"));
		Map parameters = new HashMap();
		parameters.put("application-name", applicationName);
		parameters.put("version", applicationVersion);
		mojo.setParameters(parameters);
		mojo.execute();
	}

	private void generatePersistenceBeanConfig() throws MojoExecutionException,
			MojoFailureException {
		ManyToManyMojo mojo = new ManyToManyMojo();
		initPersistenceMojo(mojo, "Beans");
		mojo.setDestDir(generatedXmlDir);
		mojo.setFileNameRegex("\\.xml");
		mojo.setFileNameReplacement("-beans\\.xml");
		Map parameters = new HashMap();
		parameters.put("merged-file-name", mergedPersistenceFile);
		mojo.setParameters(parameters);
		mojo.execute();
	}

	private void generatePersistenceEnumJava() throws MojoExecutionException,
			MojoFailureException {
		ManyToDynamicMojo mojo = new ManyToDynamicMojo();
		initPersistenceMojo(mojo, "EnumJava");
		mojo.setDestDir(generatedJavaDir);
		mojo.execute();
	}

	private void generatePersistenceEnumHbmXml() throws MojoExecutionException,
			MojoFailureException {
		ManyToDynamicMojo mojo = new ManyToDynamicMojo();
		initPersistenceMojo(mojo, "EnumHbmXml");
		mojo.setDestDir(generatedJavaDir);
		mojo.execute();
	}

	private void generatePersistenceEnumSql() throws MojoExecutionException,
			MojoFailureException {
		ManyToOneMojo mojo = new ManyToOneMojo();
		initPersistenceMojo(mojo, "EnumSql");
		mojo.setDestFile(enumInitFile);
		Map parameters = new HashMap();
		parameters.put("merged-file-name", mergedPersistenceFile);
		mojo.setParameters(parameters);
		mojo.execute();
	}

	private void generatePersistenceDao() throws MojoExecutionException,
			MojoFailureException {
		ManyToDynamicMojo mojo = new ManyToDynamicMojo();
		initPersistenceMojo(mojo, "DAO");
		mojo.setDestDir(generatedJavaDir);
		mojo.execute();
	}

	private void generatePersistenceHibernateDao()
			throws MojoExecutionException, MojoFailureException {
		ManyToDynamicMojo mojo = new ManyToDynamicMojo();
		initPersistenceMojo(mojo, "HibernateDAO");
		mojo.setDestDir(generatedJavaDir);
		mojo.execute();
	}

	private void generatePersistenceControllerBase()
			throws MojoExecutionException, MojoFailureException {
		ManyToDynamicMojo mojo = new ManyToDynamicMojo();
		initPersistenceMojo(mojo, "ControllerBase");
		mojo.setDestDir(generatedJavaDir);
		mojo.execute();
	}

	private void generatePersistenceController() throws MojoExecutionException,
			MojoFailureException {
		ManyToDynamicMojo mojo = new ManyToDynamicMojo();
		initPersistenceMojo(mojo, "Controller");
		mojo.setDestDir(generatedJavaDir);
		mojo.execute();
	}

	private void generatePersistenceControllerImplBase()
			throws MojoExecutionException, MojoFailureException {
		ManyToDynamicMojo mojo = new ManyToDynamicMojo();
		initPersistenceMojo(mojo, "ControllerImplBase");
		mojo.setDestDir(generatedJavaDir);
		mojo.execute();
	}

	private void generatePersistenceControllerImpl()
			throws MojoExecutionException, MojoFailureException {
		ManyToDynamicMojo mojo = new ManyToDynamicMojo();
		initPersistenceMojo(mojo, "ControllerImpl");
		mojo.setDestDir(generatedJavaDir);
		mojo.execute();
	}

	private void generatePersistenceHbmXml() throws MojoExecutionException,
			MojoFailureException {
		ManyToDynamicMojo mojo = new ManyToDynamicMojo();
		initPersistenceMojo(mojo, "HbmXml");
		mojo.setDestDir(generatedJavaDir);
		Map parameters = new HashMap();
		parameters.put("merged-file-name", mergedPersistenceFile);
		mojo.setParameters(parameters);
		mojo.execute();
	}

	private void generatePersistenceContext() throws MojoExecutionException,
			MojoFailureException {
		ManyToOneMojo mojo = new ManyToOneMojo();
		initPersistenceMojo(mojo, "PersistenceContext");
		mojo.setDestFile(persistenceContextFile);
		Map parameters = new HashMap();
		parameters.put("merged-file-name", mergedPersistenceFile);
		mojo.setParameters(parameters);
		mojo.execute();
	}

	public void generatePersistenceHibernateCfg()
			throws MojoExecutionException, MojoFailureException {
		ManyToOneMojo mojo = new ManyToOneMojo();
		initPersistenceMojo(mojo, "HibernateCfg");
		mojo.setSrcFile(hibernateCfgXmlSrcFile);
		mojo.setDestFile(hibernateCfgXmlDestFile);
		Map parameters = new HashMap();
		parameters.put("merged-file-name", mergedPersistenceFile);
		mojo.setParameters(parameters);
		mojo.execute();
	}

	public void generatePersistenceSessionFactoryContext()
			throws MojoExecutionException, MojoFailureException {
		ManyToOneMojo mojo = new ManyToOneMojo();
		initPersistenceMojo(mojo, "SessionFactoryContext");
		mojo.setSrcFile(sessionFactoryContextSrcFile);
		mojo.setDestFile(sessionFactoryContextDestFile);
		Map parameters = new HashMap();
		parameters.put("merged-file-name", mergedPersistenceFile);
		mojo.setParameters(parameters);
		mojo.execute();
	}

	public void generatePersistenceCodeTableInit()
			throws MojoExecutionException, MojoFailureException {
		ManyToOneMojo mojo = new ManyToOneMojo();
		initPersistenceMojo(mojo, "XmlToSqlInserts");
		mojo.setSrcFile(codeTableInitSrcFile);
		mojo.setDestFile(codeTableInitDestFile);
		mojo.execute();
	}

	private void initPersistenceMojo(FromManyBase mojo, String template) {
		initMojoBaseProperties(mojo);
		mojo.setSrcIncludes(persistenceSrcIncludes);
		mojo.setXslTemplate("generator/seaf-persistence/" + template + ".xsl");
	}

	public boolean isFull() {
		return "full".equals(generatePersistenceMode);
	}

}
