package net.sf.seaf.mojo.util;

import java.io.File;

import net.sf.jbg.mojo.BeansMojo;
import net.sf.xsltmp.FromManyBase;
import net.sf.xsltmp.util.EncodingUtils;

import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

public class GeneratorBase {

	private final MavenProject project;
	private final ArchiverManager archiverManager;
	private final Log log;
	private final File configurationDir;
	private String sourceEncoding;

	public GeneratorBase(MavenProject project, ArchiverManager archiverManager,
			Log log, File configurationDir, String sourceEncoding) {
		this.project = project;
		this.archiverManager = archiverManager;
		this.log = log;
		this.configurationDir = configurationDir;
		this.sourceEncoding = sourceEncoding;
	}

	protected void initMojoBaseProperties(FromManyBase mojo) {
		mojo.setProject(project);
		mojo.setArchiverManager(archiverManager);
		mojo.setLog(log);
		mojo.setSrcDir(configurationDir);
		mojo.setSourceEncoding(getSourceEncoding());
	}

	protected void initMojoBaseProperties(BeansMojo mojo) {
		mojo.setProject(project);
		mojo.setArchiverManager(archiverManager);
		mojo.setLog(log);
		mojo.setSourceEncoding(getSourceEncoding());
	}

	public String getSourceEncoding() {
		sourceEncoding = ENCODING_UTILS.defaultByPlatformEncoding(
				sourceEncoding, log);
		return sourceEncoding;
	}

	private static final EncodingUtils ENCODING_UTILS = new EncodingUtils();

}
