package net.sf.seaf.mojo.util;

import java.io.File;

import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;

public class FilesChangedUtils {

	public boolean filesChanged(File baseDir, String srcIncludes,
			File timestampFile) {
		DirectoryScanner scanner = new DirectoryScanner();
		scanner.setBasedir(baseDir);
		scanner.setIncludes(StringUtils.split(srcIncludes, ","));
		scanner.scan();
		String[] sourceFileNames = scanner.getIncludedFiles();
		for (int i = 0; i < sourceFileNames.length; i++) {
			File srcFile = new File(baseDir, sourceFileNames[i]);
			if (srcFile.lastModified() > timestampFile.lastModified()) {
				return true;
			}
		}
		return false;
	}

}
