package net.sf.seaf.mojo.util;

import java.io.File;

import net.sf.jbg.mojo.BeansMojo;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

public class BeansGenerator extends GeneratorBase {

	private final File generatedXmlDir;
	private final File generatedJavaDir;

	public BeansGenerator(MavenProject project,
			ArchiverManager archiverManager, Log log, File configurationDir,
			String sourceEncoding, File generatedXmlDir, File generatedJavaDir) {
		super(project, archiverManager, log, configurationDir, sourceEncoding);
		this.generatedXmlDir = generatedXmlDir;
		this.generatedJavaDir = generatedJavaDir;
	}

	public void generateBeans() throws MojoExecutionException,
			MojoFailureException {
		BeansMojo mojo = new BeansMojo();
		initMojoBaseProperties(mojo);
		mojo.setSrcDir(generatedXmlDir);
		mojo.setDestDir(generatedJavaDir);
		mojo.setSrcIncludes("**/*-beans.xml");
		mojo.execute();
	}

}
