/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.awt.Font;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectFactory {
    private static final Map<Class<?>, Constructor<?>> stringConstructorMap;
    private static final Map<Class<?>, Class<?>> primitives;

    private ObjectFactory() {
    }

    public static Object createFromString(Class<?> clazz, String string) {
        if (clazz == String.class) {
            return string == null ? "" : string;
        }
        if (clazz == Integer.TYPE && string.length() == 1) {
            return string.charAt(0) - 48;
        }
        if (clazz == Font.class) {
            return Font.decode(string);
        }
        Class<?> clazz2 = primitives.get(clazz);
        if (clazz2 != null) {
            clazz = clazz2;
        }
        try {
            if (string == null) {
                return clazz.newInstance();
            }
            Constructor<?> constructor = stringConstructorMap.get(clazz);
            if (constructor == null) {
                constructor = clazz.getConstructor(String.class);
                stringConstructorMap.put(clazz, constructor);
            }
            return constructor.newInstance(string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException(clazz.getName() + " has no" + " constructor with a single string as a parameter");
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException(clazz.getName() + " has no" + " constructor with an empty parameter list");
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(clazz.getName() + " has a" + " constructor with a single string as a parameter, but" + " it cannot be invoked with the argument \"" + string + "\", which led to an exception/error of type " + throwable.getClass().getSimpleName() + " with the message: " + throwable.getMessage());
        }
    }

    static {
        primitives = new HashMap();
        primitives.put(Integer.TYPE, Integer.class);
        primitives.put(Float.TYPE, Float.class);
        primitives.put(Double.TYPE, Double.class);
        primitives.put(Character.TYPE, Character.class);
        primitives.put(Long.TYPE, Long.class);
        primitives.put(Boolean.TYPE, Boolean.class);
        stringConstructorMap = new HashMap();
    }
}

