/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.sdedit.util.ObjectFactory;

public final class Grep {
    private static final Map<String, Pattern> patternCache = new HashMap<String, Pattern>();
    private static final Map<Class<?>, Map<String, PropertyDescriptor>> descriptorCache = new HashMap();

    private Grep() {
    }

    public static String[] parse(String string, String string2) {
        Matcher matcher;
        Pattern pattern = patternCache.get(string);
        if (pattern == null) {
            pattern = Pattern.compile(string);
            patternCache.put(string, pattern);
        }
        if (!(matcher = pattern.matcher(string2)).matches()) {
            return null;
        }
        String[] stringArray = new String[matcher.groupCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = Grep.unescape(matcher.group(i + 1));
        }
        return stringArray;
    }

    private static final String unescape(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (n) {
                case 0: {
                    if (c != '\\') {
                        stringBuffer.append(c);
                        continue block4;
                    }
                    n = 1;
                    continue block4;
                }
                case 1: {
                    stringBuffer.append(c);
                    n = 0;
                    continue block4;
                }
            }
        }
        if (n == 1) {
            stringBuffer.append('\\');
        }
        return stringBuffer.toString();
    }

    public static boolean parseAndSetProperties(Object object, String string, String string2, String ... stringArray) throws IntrospectionException {
        String[] stringArray2 = Grep.parse(string, string2);
        if (stringArray2 == null) {
            return false;
        }
        if (stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException("number of groups does not match number of properties");
        }
        Map<String, PropertyDescriptor> map = descriptorCache.get(object.getClass());
        if (map == null) {
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
            map = new HashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                if (propertyDescriptor.getWriteMethod() == null) continue;
                map.put(propertyDescriptor.getName(), propertyDescriptor);
            }
            descriptorCache.put(object.getClass(), map);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            PropertyDescriptor propertyDescriptor = map.get(stringArray[i]);
            if (propertyDescriptor == null) {
                throw new IllegalArgumentException("property " + stringArray[i] + " does not exist");
            }
            Object object2 = ObjectFactory.createFromString(propertyDescriptor.getPropertyType(), stringArray2[i]);
            try {
                propertyDescriptor.getWriteMethod().invoke(object, object2);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IllegalArgumentException("cannot write property " + stringArray[i]);
            }
        }
        return true;
    }
}

