/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocUtil {
    private static DocumentBuilder documentBuilder;
    private static Transformer transformer;
    private static XPathFactory xPathFactory;

    private DocUtil() {
    }

    public static String evalXPathAsString(Document document, String string) throws XMLException {
        XPath xPath = xPathFactory.newXPath();
        try {
            return xPath.evaluate("/extension/description", document);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new XMLException("Could not evaluate XPath: " + string, xPathExpressionException);
        }
    }

    public static String evaluateCDATA(Document document, String string) throws XMLException {
        StringBuffer stringBuffer = new StringBuffer();
        Element element = (Element)DocUtil.evalXPathAsNode(document, string);
        if (element != null) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!(nodeList.item(i) instanceof CDATASection)) continue;
                stringBuffer.append(((CDATASection)nodeList.item(i)).getTextContent());
            }
        }
        return stringBuffer.toString();
    }

    public static Node evalXPathAsNode(Document document, String string) throws XMLException {
        XPath xPath = xPathFactory.newXPath();
        try {
            Node node = (Node)xPath.evaluate(string, document, XPathConstants.NODE);
            return node;
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new XMLException("Could not evaluate XPath: " + string, xPathExpressionException);
        }
    }

    public static NodeList evalXPathAsNodeList(Document document, String string) throws XMLException {
        XPath xPath = xPathFactory.newXPath();
        try {
            return (NodeList)xPath.evaluate(string, document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new XMLException("Could not evaluate XPath: " + string, xPathExpressionException);
        }
    }

    public static Document newDocument() {
        return documentBuilder.newDocument();
    }

    public static void writeDocument(Document document, String string, OutputStream outputStream) throws IOException, XMLException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        transformer.setOutputProperty("encoding", string);
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(outputStreamWriter);
        try {
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            throw new XMLException("writeDocument failed", transformerException);
        }
    }

    public static Document readDocument(InputStream inputStream, String string) throws IOException, XMLException {
        Document document;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
        InputSource inputSource = new InputSource(new BufferedReader(inputStreamReader));
        try {
            document = documentBuilder.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new XMLException("readDocument failed", sAXException);
        }
        return document;
    }

    static {
        xPathFactory = XPathFactory.newInstance();
        DocumentBuilderFactory documentBuilderFactory = null;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            transformer = TransformerFactory.newInstance().newTransformer();
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class XMLException
    extends Exception {
        private XMLException(String string) {
            super(string);
        }

        private XMLException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

