/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.lang.reflect.Method;
import java.net.URI;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class Browser
implements HyperlinkListener {
    private static Browser instance;
    private static final Object desktop;
    private static final Method browseMethod;
    private static final Method mailtoMethod;
    private static String jdklt6;
    private static String notSupported;
    private static final boolean jdk6;
    private static final boolean supported;

    private Browser() {
    }

    public static Browser getBrowser() {
        if (instance == null) {
            instance = new Browser();
        }
        return instance;
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getURL().getProtocol() == null || !hyperlinkEvent.getURL().getProtocol().equals("http") && !hyperlinkEvent.getURL().getProtocol().equals("mailto")) {
            return;
        }
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (!jdk6) {
                JOptionPane.showMessageDialog(null, jdklt6);
                return;
            }
            if (desktop == null || !supported) {
                JOptionPane.showMessageDialog(null, notSupported);
                return;
            }
            if (hyperlinkEvent.getURL().getProtocol().equals("http")) {
                if (browseMethod != null) {
                    try {
                        URI uRI = hyperlinkEvent.getURL().toURI();
                        browseMethod.invoke(desktop, uRI);
                    }
                    catch (Exception exception) {}
                }
            } else if (hyperlinkEvent.getURL().getProtocol().equals("mailto") && mailtoMethod != null) {
                try {
                    URI uRI = hyperlinkEvent.getURL().toURI();
                    mailtoMethod.invoke(desktop, uRI);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    static {
        jdklt6 = "Browsing is only supported by\nJDK 6 or higher";
        notSupported = "Operation not supported by\nyour environment";
        Object object = null;
        Method method = null;
        Method method2 = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            Class<?> clazz = Class.forName("java.awt.Desktop");
            bl = true;
            Method method3 = clazz.getMethod("isDesktopSupported", new Class[0]);
            bl2 = (Boolean)method3.invoke(null, new Object[0]);
            if (bl2) {
                Method method4 = clazz.getMethod("getDesktop", new Class[0]);
                object = method4.invoke(null, new Object[0]);
                method = clazz.getMethod("browse", URI.class);
                method2 = clazz.getMethod("mail", URI.class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        jdk6 = bl;
        supported = bl2;
        desktop = object;
        browseMethod = method;
        mailtoMethod = method2;
    }
}

