/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import net.sf.sdedit.Constants;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.config.ConfigurationManager;
import net.sf.sdedit.config.GlobalConfiguration;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.error.DiagramError;
import net.sf.sdedit.icons.Icons;
import net.sf.sdedit.ui.PanelPaintDevice;
import net.sf.sdedit.ui.UserInterface;
import net.sf.sdedit.ui.UserInterfaceListener;
import net.sf.sdedit.ui.components.ATabbedPane;
import net.sf.sdedit.ui.components.ATabbedPaneListener;
import net.sf.sdedit.ui.components.AdvancedHelpPanel;
import net.sf.sdedit.ui.components.FullScreen;
import net.sf.sdedit.ui.components.FullScreenListener;
import net.sf.sdedit.ui.components.GrabbableViewport;
import net.sf.sdedit.ui.components.HelpPanel;
import net.sf.sdedit.ui.components.MenuBar;
import net.sf.sdedit.ui.components.OptionDialog;
import net.sf.sdedit.ui.components.ScalePanel;
import net.sf.sdedit.ui.components.buttons.Activator;
import net.sf.sdedit.ui.components.buttons.EnableComponents;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.ConfigurationAction;
import net.sf.sdedit.ui.components.configuration.ConfigurationDialog;
import net.sf.sdedit.ui.components.configuration.ConfigurationUI;
import net.sf.sdedit.ui.impl.AboutDialog;
import net.sf.sdedit.ui.impl.LookAndFeelManager;
import net.sf.sdedit.ui.impl.PrintDialog;
import net.sf.sdedit.ui.impl.RedrawThread;
import net.sf.sdedit.ui.impl.Tab;
import net.sf.sdedit.util.OS;
import net.sf.sdedit.util.Predicate;
import net.sf.sdedit.util.UIUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UserInterfaceImpl
extends JFrame
implements Constants,
UserInterface,
ChangeListener,
FullScreenListener,
HyperlinkListener,
ATabbedPaneListener {
    private JFileChooser fileChooser;
    private ATabbedPane tabbedPane;
    private JPanel bottomPanel;
    private MenuBar menuBar;
    private List<UserInterfaceListener> listeners;
    private FullScreen fullScreen;
    private ScalePanel scalePanel;
    private RedrawThread redrawThread;
    private PrintDialog printDialog;
    private JToolBar toolbar;
    private JTabbedPane configurationPane;
    private ConfigurationDialog preferencesDialog;
    private EnableComponents enableComponents;
    private ConfigurationUI<GlobalConfiguration> globalConfigurationUI;
    private ConfigurationUI<Configuration> localConfigurationUI;
    private final Activator nonEmptyDiagramActivator = new Activator(){

        public boolean isEnabled() {
            return !UserInterfaceImpl.this.isDiagramBlank();
        }
    };

    @Override
    public void showAboutDialog(URL uRL) {
        new AboutDialog(this, uRL).setVisible(true);
    }

    public UserInterfaceImpl() {
        LookAndFeelManager.instance().setFont(ConfigurationManager.getGlobalConfiguration().getGuiFont());
        this.setDefaultCloseOperation(0);
        this.enableComponents = new EnableComponents();
        this.preferencesDialog = new ConfigurationDialog(this);
        this.preferencesDialog.setTitle("Preferences");
        this.preferencesDialog.getContentPane().setLayout(new BorderLayout());
        this.preferencesDialog.setModal(true);
        this.preferencesDialog.setSize(new Dimension(675, 475));
        LookAndFeelManager.instance().register(this.preferencesDialog);
        this.configurationPane = new JTabbedPane();
        this.preferencesDialog.getContentPane().add((Component)this.configurationPane, "Center");
        this.globalConfigurationUI = new ConfigurationUI<GlobalConfiguration>(this.preferencesDialog, ConfigurationManager.getGlobalConfigurationBean(), ConfigurationManager.GLOBAL_DEFAULT, null, "Restore defaults|Changes the current global preferences so that they are equal to the default preferences", "<html>In this tab you can change global preferences. On exit, they are stored in the file <tt>" + Constants.GLOBAL_CONF_FILE.getAbsolutePath() + "</tt>.");
        this.globalConfigurationUI.setBorder(BorderFactory.createEmptyBorder(15, 15, 0, 15));
        this.preferencesDialog.addConfigurationUI(this.globalConfigurationUI);
        ConfigurationUI<Configuration> configurationUI = new ConfigurationUI<Configuration>(this.preferencesDialog, ConfigurationManager.getDefaultConfigurationBean(), ConfigurationManager.LOCAL_DEFAULT, null, "Restore defaults|Changes the initial preferences (to be used for newly created diagrams) such that they are equal to the default settings", "<html>This tab is for adjusting the (initial) preferences that are used for newly created diagrams. They are stored along with the global preferences.");
        configurationUI.setBorder(BorderFactory.createEmptyBorder(15, 15, 0, 15));
        this.preferencesDialog.addConfigurationUI(configurationUI);
        this.localConfigurationUI = new ConfigurationUI<Configuration>(this.preferencesDialog, ConfigurationManager.createNewDefaultConfiguration(), ConfigurationManager.getDefaultConfigurationBean(), "Save as initial|Saves the current diagram's preferences as the initial preferences (to be used for all newly created diagrams)", "Restore initial|Changes the current diagram's preferences such that they are equal to the initial preferences", "<html>This tab is for changing the preferences for the diagram currently being displayed.<br>They will be stored  when the diagram is saved as an <tt>.sdx</tt>-file.");
        this.localConfigurationUI.setBorder(BorderFactory.createEmptyBorder(15, 15, 0, 15));
        for (JPanel jPanel : this.localConfigurationUI.getCategoryPanels()) {
            LookAndFeelManager.instance().registerOrphan(jPanel);
        }
        this.preferencesDialog.addConfigurationUI(this.localConfigurationUI);
        this.configurationPane.add("Global preferences", this.globalConfigurationUI);
        this.configurationPane.add("Initial diagram preferences", configurationUI);
        this.configurationPane.addTab("Current diagram preferences", this.localConfigurationUI);
        for (JPanel jPanel : this.globalConfigurationUI.getCategoryPanels()) {
            LookAndFeelManager.instance().registerOrphan(jPanel);
        }
        for (JPanel jPanel : configurationUI.getCategoryPanels()) {
            LookAndFeelManager.instance().registerOrphan(jPanel);
        }
        this.listeners = new LinkedList<UserInterfaceListener>();
        this.redrawThread = new RedrawThread(this);
        this.redrawThread.start();
        this.menuBar = new MenuBar();
        this.toolbar = new JToolBar();
        this.toolbar.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.toolbar.setFloatable(false);
    }

    @Override
    public void addListener(UserInterfaceListener userInterfaceListener) {
        this.listeners.add(userInterfaceListener);
    }

    @Override
    public void addCategory(String string, String string2) {
        ImageIcon imageIcon = string2 == null || string2.equals("") ? null : Icons.getIcon(string2);
        this.menuBar.addMenu(string, imageIcon);
    }

    @Override
    public void addAction(String string, Action action, Activator activator) {
        Object object;
        if (action != null && (object = (String)action.getValue("icon-name")) != null) {
            ImageIcon imageIcon = Icons.getIcon((String)object);
            action.putValue("SmallIcon", imageIcon);
        }
        object = this.menuBar.addAction(string, action, -1);
        if (activator != null) {
            this.registerComponent((JComponent)object, activator);
        }
    }

    @Override
    public void addConfigurationAction(String string, ConfigurationAction<?> configurationAction, Activator activator) {
        JCheckBoxMenuItem jCheckBoxMenuItem = MenuBar.makeMenuItem(configurationAction.getValue("Name").toString(), JCheckBoxMenuItem.class);
        this.menuBar.addItem(string, jCheckBoxMenuItem);
        jCheckBoxMenuItem.setToolTipText(configurationAction.getValue("ShortDescription").toString());
        jCheckBoxMenuItem.setIcon((Icon)configurationAction.getValue("SmallIcon"));
        if (activator != null) {
            this.registerComponent(jCheckBoxMenuItem, activator);
        }
        jCheckBoxMenuItem.addActionListener(configurationAction);
        this.enableComponents.registerConfigurationAction(configurationAction, jCheckBoxMenuItem);
    }

    void registerComponent(JComponent jComponent, Activator activator) {
        this.enableComponents.registerButton(jComponent, activator);
    }

    void enableComponents() {
        this.enableComponents.enableComponents();
    }

    @Override
    public void help(String string, String string2, boolean bl) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (this.tabbedPane.getComponentAt(i) instanceof Tab || !this.tabbedPane.getTitleAt(i).equals(string) && !this.tabbedPane.getTitleAt(i).startsWith(string + "-")) continue;
            this.tabbedPane.setSelectedIndex(i);
            return;
        }
        JComponent jComponent = bl ? new AdvancedHelpPanel(this.getClass().getResource(string2), this) : new JScrollPane(new HelpPanel(this.getClass().getResource(string2), this).getPane());
        this.tabbedPane.addTab(jComponent, string, Icons.getIcon("help"));
    }

    protected void fireCodeChanged(boolean bl) {
        for (UserInterfaceListener userInterfaceListener : this.listeners) {
            userInterfaceListener.codeChanged(bl);
        }
    }

    protected void fireCurrentTabClosing() {
        for (UserInterfaceListener userInterfaceListener : this.listeners) {
            userInterfaceListener.currentTabClosing();
        }
    }

    public void fireHyperlinkClicked(String string) {
        for (UserInterfaceListener userInterfaceListener : this.listeners) {
            userInterfaceListener.hyperlinkClicked(string);
        }
    }

    @Override
    public void currentTabClosing() {
        this.fireCurrentTabClosing();
    }

    @Override
    public void showUI() {
        this.setIconImage(Icons.getIcon("icon").getImage());
        this.fileChooser = new JFileChooser();
        this.fileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.tabbedPane = new ATabbedPane();
        this.tabbedPane.addChangeListener(this);
        this.tabbedPane.addListener(this);
        container.add((Component)this.tabbedPane, "Center");
        container.add((Component)this.toolbar, "North");
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BorderLayout());
        this.scalePanel = new ScalePanel(false);
        Dimension dimension = new Dimension(140, 24);
        this.scalePanel.setMaximumSize(dimension);
        this.scalePanel.setMinimumSize(dimension);
        this.scalePanel.setPreferredSize(dimension);
        this.scalePanel.setOpaque(false);
        this.addToolbarSeparator();
        this.toolbar.add(this.scalePanel);
        this.registerComponent(this.scalePanel, this.nonEmptyDiagramActivator);
        this.addToolbarSeparator();
        this.addToToolbar(this.scalePanel.normalSizeAction, this.nonEmptyDiagramActivator);
        this.addToToolbar(this.scalePanel.fitHeightAction, this.nonEmptyDiagramActivator);
        this.addToToolbar(this.scalePanel.fitWidthAction, this.nonEmptyDiagramActivator);
        this.addToToolbar(this.scalePanel.fitWindowAction, this.nonEmptyDiagramActivator);
        container.add((Component)this.bottomPanel, "South");
        int n = Toolkit.getDefaultToolkit().getScreenSize().width;
        int n2 = Toolkit.getDefaultToolkit().getScreenSize().height;
        int n3 = (int)(0.8 * (double)n);
        int n4 = (int)(0.8 * (double)n2);
        int n5 = (int)(0.1 * (double)n);
        int n6 = (int)(0.1 * (double)n2);
        this.setSize(n3, n4);
        this.setLocation(n5, n6);
        this.fullScreen = new FullScreen();
        this.fullScreen.addListener(this);
        LookAndFeelManager.instance().register(this.fullScreen);
        this.setJMenuBar(this.menuBar);
        LookAndFeelManager.instance().register(this);
        ConfigurationManager.getGlobalConfigurationBean().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                UserInterfaceImpl.this.enableComponents();
            }
        });
        this.enableComponents();
        this.setVisible(true);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Tab tab;
        this.setTitle(this.tabbedPane.getCurrentTitle() + " - Quick Sequence Diagram Editor");
        Action action = this.menuBar.getActionByName("[F12]&Close");
        if (action != null) {
            action.setEnabled(this.tabbedPane.getTabCount() > 1);
        }
        if ((tab = this.currentTab()) != null) {
            tab.leaveFilterMode();
            this.scalePanel.setScalable(tab.getZoomPane());
            this.fireCodeChanged(false);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    tab.getTextArea().requestFocusInWindow();
                }
            });
        }
        this.enableComponents();
    }

    @Override
    public void setTabTitle(String string) {
        this.tabbedPane.setTabTitle(string);
        this.setTitle(string + " - Quick Sequence Diagram Editor");
    }

    @Override
    public String addTab(String string, Bean<Configuration> bean) {
        Tab tab = new Tab(this, this.redrawThread, ConfigurationManager.getGlobalConfiguration().getEditorFont(), bean);
        for (UserInterfaceListener userInterfaceListener : this.listeners) {
            if (userInterfaceListener.getPanelPaintDeviceListener() == null) continue;
            tab.addPanelPaintDeviceListener(userInterfaceListener.getPanelPaintDeviceListener());
        }
        String string2 = this.tabbedPane.addTab(tab, string);
        this.currentTab().layout(bean.getDataObject().isVerticallySplit() ? 1 : 0);
        this.enableComponents();
        return string2;
    }

    public Tab currentTab() {
        Component component = this.tabbedPane.getSelectedComponent();
        if (component instanceof Tab) {
            return (Tab)component;
        }
        return null;
    }

    @Override
    public File getCurrentFile() {
        return this.currentTab().getFile();
    }

    @Override
    public void setCurrentFile(File file) {
        this.currentTab().setFile(file);
        if (file != null) {
            this.tabbedPane.setToolTipTextAt(this.tabbedPane.getSelectedIndex(), file.getAbsolutePath());
        }
    }

    @Override
    public boolean removeCurrentTab(boolean bl) {
        this.setErrorStatus(false, "", -1, -1);
        boolean bl2 = this.tabbedPane.removeCurrentTab(bl);
        this.enableComponents();
        return bl2;
    }

    @Override
    public void addToToolbar(Action action, Activator activator) {
        JButton jButton = this.toolbar.add(UserInterfaceImpl.makeToolbarAction(action));
        jButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 5));
        jButton.setOpaque(false);
        jButton.setMargin(new Insets(1, 1, 1, 1));
        if (activator != null) {
            this.registerComponent(jButton, activator);
        }
    }

    @Override
    public void addToolbarSeparator() {
        JSeparator jSeparator = new JSeparator();
        jSeparator.setOrientation(1);
        Dimension dimension = new Dimension(10, 25);
        jSeparator.setMinimumSize(dimension);
        jSeparator.setPreferredSize(dimension);
        jSeparator.setMaximumSize(dimension);
        this.toolbar.add(jSeparator);
    }

    public static Action makeToolbarAction(final Action action) {
        return new AbstractAction(){
            {
                this.putValue("Name", action.getValue("Name"));
                this.putValue("ShortDescription", action.getValue("ShortDescription"));
                String string = (String)action.getValue("icon-name");
                if (string != null) {
                    ImageIcon imageIcon = Icons.getIcon("large/" + string);
                    this.putValue("SmallIcon", imageIcon);
                } else {
                    this.putValue("SmallIcon", action.getValue("SmallIcon"));
                }
            }

            public void actionPerformed(ActionEvent actionEvent) {
                action.actionPerformed(actionEvent);
            }
        };
    }

    @Override
    public void configure(boolean bl) {
        Bean<Configuration> bean = this.getConfiguration();
        if (bean != null) {
            this.localConfigurationUI.setBean(bean);
            this.localConfigurationUI.setEnabled(true);
        } else {
            this.localConfigurationUI.setEnabled(false);
        }
        this.configurationPane.setSelectedIndex(bl ? 2 : 0);
        UIUtilities.centerWindow(this.preferencesDialog, this);
        this.preferencesDialog.setVisible(true);
    }

    @Override
    public void redraw() {
        if (this.fullScreen.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UserInterfaceImpl.this.fullScreen.getContentPane().repaint();
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UserInterfaceImpl.this.fullScreen.getZoomPane().getScrollPane().revalidate();
                }
            });
            return;
        }
        Tab tab = this.currentTab();
        if (tab != null) {
            tab.redraw();
        }
    }

    @Override
    public void fullScreen() {
        if (this.fullScreen == null) {
            this.errorMessage("Full-screen mode is not supported\nby your graphics environment.");
            return;
        }
        Diagram diagram = this.getDiagram();
        if (diagram != null) {
            PanelPaintDevice panelPaintDevice = (PanelPaintDevice)diagram.getPaintDevice();
            this.setVisible(false);
            this.fullScreen.display(panelPaintDevice.getPanel());
            this.fullScreen.getZoomPane().fitSize();
        }
    }

    @Override
    public void fullScreenModeLeft() {
        this.setVisible(true);
        Tab tab = this.currentTab();
        if (tab != null) {
            this.scalePanel.setScalable(tab.getZoomPane());
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UserInterfaceImpl.this.requestFocus();
            }
        });
    }

    @Override
    public void clearDisplay() {
        Tab tab = this.currentTab();
        if (tab != null) {
            tab.clear();
        }
        this.enableComponents();
    }

    @Override
    public void home() {
        Tab tab = this.currentTab();
        if (tab != null) {
            tab.home();
        }
    }

    @Override
    public String getCode() {
        Tab tab = this.currentTab();
        if (tab != null) {
            return tab.getCode();
        }
        return "";
    }

    @Override
    public void setCode(String string) {
        Tab tab = this.currentTab();
        if (tab != null) {
            tab.setCode(string);
            tab.home();
        }
        this.enableComponents();
        if (!ConfigurationManager.getGlobalConfiguration().isAutoUpdate()) {
            this.fireCodeChanged(false);
        }
    }

    @Override
    public void setStatus(String string) {
        Tab tab = this.currentTab();
        if (tab != null) {
            tab.setStatus(string);
        }
    }

    @Override
    public void setQuitAction(final Action action) {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                action.actionPerformed(new ActionEvent(this, 1001, ""));
            }
        });
    }

    @Override
    public int confirmOrCancel(String string) {
        int n = JOptionPane.showConfirmDialog(this, string, "Confirmation", 1);
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        return -1;
    }

    @Override
    public boolean confirm(String string) {
        return this.confirmOrCancel(string) == 1;
    }

    @Override
    public File[] getFiles(boolean bl, boolean bl2, String string, String string2, File file, String ... stringArray) {
        Object object;
        Object object2;
        int n;
        this.fileChooser = file == null ? new JFileChooser(this.fileChooser.getCurrentDirectory()) : new JFileChooser(file);
        if (string2 != null) {
            this.fileChooser.setSelectedFile(new File(file, string2));
        }
        this.fileChooser.setMultiSelectionEnabled(bl2);
        if (stringArray.length > 0) {
            for (n = 0; n < stringArray.length; n += 2) {
                object2 = stringArray[n];
                object = stringArray[n + 1].toLowerCase();
                MyFileFilter myFileFilter = new MyFileFilter((String)object2){
                    final /* synthetic */ String val$description;
                    {
                        this.val$description = string;
                    }

                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        String string = file.getName().toLowerCase();
                        return string.endsWith(this.suffix);
                    }

                    public String getDescription() {
                        return this.val$description;
                    }
                };
                myFileFilter.suffix = object;
                this.fileChooser.addChoosableFileFilter(myFileFilter);
            }
            if (string2 != null && (n = string2.lastIndexOf(46)) >= 0) {
                object2 = string2.substring(n + 1);
                object = this.fileChooser.getChoosableFileFilters();
                int n2 = ((FileFilter[])object).length;
                for (int i = 0; i < n2; ++i) {
                    FileFilter fileFilter = object[i];
                    if (!(fileFilter instanceof MyFileFilter) || !((MyFileFilter)fileFilter).suffix.equals(object2)) continue;
                    this.fileChooser.setFileFilter(fileFilter);
                    break;
                }
            }
        }
        this.fileChooser.setDialogTitle(string);
        n = bl ? this.fileChooser.showOpenDialog(this) : this.fileChooser.showSaveDialog(this);
        if (n == 0) {
            if (bl2) {
                if (this.fileChooser.getSelectedFiles() == null || this.fileChooser.getSelectedFiles().length == 0) {
                    return null;
                }
                return this.fileChooser.getSelectedFiles();
            }
            object2 = this.fileChooser.getSelectedFile();
            if (!bl && (object = this.fileChooser.getFileFilter()) instanceof MyFileFilter) {
                String string3 = ((MyFileFilter)object).suffix;
                object2 = UIUtilities.affixType((File)object2, string3);
            }
            return new File[]{object2};
        }
        return null;
    }

    @Override
    public void message(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    @Override
    public void errorMessage(String string) {
        JOptionPane.showMessageDialog(this, string, "Error", 0);
    }

    @Override
    public void moveCursorToPosition(int n) {
        this.currentTab().moveCursorToPosition(n);
    }

    @Override
    public void setErrorStatus(final boolean bl, final String string, final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Tab tab = UserInterfaceImpl.this.currentTab();
                if (tab != null) {
                    tab.setError(bl, string, n, n2);
                }
            }
        });
    }

    @Override
    public boolean isClean() {
        Tab tab = this.currentTab();
        if (tab != null) {
            return tab.isClean();
        }
        return true;
    }

    @Override
    public void setClean() {
        Tab tab = this.currentTab();
        if (tab != null) {
            tab.setClean();
        }
    }

    @Override
    public void undo() {
        Tab tab = this.currentTab();
        if (tab != null) {
            tab.undo();
        }
    }

    @Override
    public void redo() {
        Tab tab = this.currentTab();
        if (tab != null) {
            tab.redo();
        }
    }

    @Override
    public int getNumberOfTabs() {
        return this.tabbedPane.getTabCount();
    }

    @Override
    public void appendText(String string, String string2) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (!this.tabbedPane.getTitleAt(i).equals(string) || !(this.tabbedPane.getComponentAt(i) instanceof Tab)) continue;
            Tab tab = (Tab)this.tabbedPane.getComponentAt(i);
            tab.append(string2);
        }
    }

    @Override
    public String getString(String string, String string2) {
        return JOptionPane.showInputDialog(this, string, string2);
    }

    public void addPredicateAction(String string, String string2, String string3, String string4, Icon icon, final Predicate predicate, boolean bl) {
        final JCheckBoxMenuItem jCheckBoxMenuItem = MenuBar.makeMenuItem(string2, JCheckBoxMenuItem.class);
        jCheckBoxMenuItem.setIcon(icon);
        jCheckBoxMenuItem.setText(string3);
        jCheckBoxMenuItem.setToolTipText(string4);
        jCheckBoxMenuItem.setSelected(bl);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                predicate.set(jCheckBoxMenuItem.isSelected());
                UserInterfaceImpl.this.fireCodeChanged(false);
            }
        });
        this.menuBar.addItem(string, jCheckBoxMenuItem);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (hyperlinkEvent.getURL().toString().startsWith("http")) {
                return;
            }
            if (hyperlinkEvent.getURL().toString().endsWith("sdx")) {
                String string = hyperlinkEvent.getURL().toString();
                string = string.substring(string.lastIndexOf(47) + 1);
                this.fireHyperlinkClicked("example:" + string);
            } else if (hyperlinkEvent.getURL().toString().indexOf(35) > 0) {
                try {
                    JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                    jEditorPane.setPage(hyperlinkEvent.getURL());
                }
                catch (Exception exception) {}
            } else if (hyperlinkEvent.getURL().toString().endsWith("html")) {
                String string = hyperlinkEvent.getURL().toString();
                string = string.substring(string.lastIndexOf(47) + 1);
                this.fireHyperlinkClicked("help:" + string);
            }
        }
    }

    @Override
    public void removeAction(String string, Action action) {
        this.menuBar.removeAction(string, action);
    }

    @Override
    public boolean selectTabWith(File file) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            Tab tab;
            if (!(this.tabbedPane.getComponentAt(i) instanceof Tab) || (tab = (Tab)this.tabbedPane.getComponentAt(i)).getFile() == null || !tab.getFile().equals(file)) continue;
            this.tabbedPane.setSelectedIndex(i);
            return true;
        }
        return false;
    }

    @Override
    public void nextTab() {
        int n = this.tabbedPane.getSelectedIndex();
        n = (n + 1) % this.tabbedPane.getTabCount();
        this.tabbedPane.setSelectedIndex(n);
    }

    @Override
    public void previousTab() {
        int n = this.tabbedPane.getSelectedIndex();
        n = n == 0 ? this.tabbedPane.getTabCount() - 1 : --n;
        this.tabbedPane.setSelectedIndex(n);
    }

    @Override
    public void showPrintDialog(String string) {
        if (this.printDialog == null) {
            this.printDialog = new PrintDialog(this);
        }
        this.printDialog.show(string);
    }

    @Override
    public void exit() {
    }

    public ScalePanel getScalePanel() {
        return this.scalePanel;
    }

    @Override
    public void layout(int n) {
        final Tab tab = this.currentTab();
        if (tab != null) {
            tab.layout(n);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    tab.getTextArea().requestFocusInWindow();
                }
            });
        }
    }

    @Override
    public void enterFilterMode() {
        Tab tab = this.currentTab();
        if (tab != null) {
            tab.enterFilterMode();
        }
    }

    @Override
    public void leaveFilterMode() {
        Tab tab = this.currentTab();
        if (tab != null) {
            tab.leaveFilterMode();
        }
    }

    @Override
    public void toggleFilterMode() {
        Tab tab = this.currentTab();
        if (tab != null) {
            tab.toggleFilterMode();
        }
    }

    @Override
    public Bean<Configuration> getConfiguration() {
        Tab tab = this.currentTab();
        return tab == null ? null : tab.getConfiguration();
    }

    @Override
    public boolean isDiagramBlank() {
        Tab tab = this.currentTab();
        if (tab == null) {
            return true;
        }
        Diagram diagram = tab.getDiagram();
        if (diagram != null) {
            return ((PanelPaintDevice)diagram.getPaintDevice()).isBlank();
        }
        return true;
    }

    @Override
    public boolean isDiagramTabSelected() {
        return this.currentTab() != null;
    }

    @Override
    public Diagram renderDiagram() {
        Tab tab = this.currentTab();
        if (tab == null) {
            return null;
        }
        tab.renderDiagram();
        return tab.getDiagram();
    }

    @Override
    public Diagram getDiagram() {
        Tab tab = this.currentTab();
        return tab == null ? null : tab.getDiagram();
    }

    @Override
    public DiagramError getDiagramError() {
        Tab tab = this.currentTab();
        return tab == null ? null : tab.getDiagramError();
    }

    public List<Tab> getTabs() {
        LinkedList<Tab> linkedList = new LinkedList<Tab>();
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (!(this.tabbedPane.getComponentAt(i) instanceof Tab)) continue;
            linkedList.add((Tab)this.tabbedPane.getComponentAt(i));
        }
        return linkedList;
    }

    @Override
    public String getOption(String string, String ... stringArray) {
        OptionDialog optionDialog = new OptionDialog(this, "Please choose an option", Icons.getIcon("question"), string);
        for (String string2 : stringArray) {
            optionDialog.addOption(string2);
        }
        return optionDialog.getOption();
    }

    static {
        String string = ConfigurationManager.getGlobalConfiguration().getLookAndFeel();
        LookAndFeelManager.instance().changeTo(string);
        if (OS.TYPE != OS.Type.WINDOWS) {
            GrabbableViewport.setHandCursorIcon(Icons.getIcon("grabbing"));
        }
    }

    private static abstract class MyFileFilter
    extends FileFilter {
        String suffix;

        private MyFileFilter() {
        }
    }
}

