/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.sdedit.Constants;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.config.ConfigurationManager;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.diagram.DiagramDataProvider;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.drawable.Arrow;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.error.DiagramError;
import net.sf.sdedit.error.FatalError;
import net.sf.sdedit.text.TextHandler;
import net.sf.sdedit.ui.PanelPaintDevice;
import net.sf.sdedit.ui.PanelPaintDeviceListener;
import net.sf.sdedit.ui.components.AutoCompletion;
import net.sf.sdedit.ui.components.Stainable;
import net.sf.sdedit.ui.components.StainedListener;
import net.sf.sdedit.ui.components.TextArea;
import net.sf.sdedit.ui.components.ZoomPane;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.impl.FilterCommandField;
import net.sf.sdedit.ui.impl.LookAndFeelManager;
import net.sf.sdedit.ui.impl.RedrawThread;
import net.sf.sdedit.ui.impl.UserInterfaceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tab
extends JPanel
implements Stainable,
DocumentListener,
AutoCompletion.SuggestionProvider,
PropertyChangeListener {
    private static final long serialVersionUID = -4105088603920744983L;
    private LinkedList<Diagram> diagramStack;
    private DiagramError error;
    private final RedrawThread redrawThread;
    private final UserInterfaceImpl ui;
    private final JLabel errorLabel;
    private final JLabel statusLabel;
    private final JPanel bottomPanel;
    private final ZoomPane zoomPane;
    private final TextArea textArea;
    private final FilterCommandField filterField;
    private final JPanel bottom;
    private File file;
    private boolean stained;
    private final List<StainedListener> stainedListeners;
    private String code;
    private int errorCharIndex;
    private long timeOfLastKeyChange;
    private JPopupMenu menu;
    private JSplitPane splitter;
    private JScrollPane textScroller;
    private boolean filterMode;
    private Bean<Configuration> configuration;
    private Bean<Configuration> oldConfiguration;
    private List<PanelPaintDeviceListener> ppdListeners;

    Tab(UserInterfaceImpl userInterfaceImpl, RedrawThread redrawThread, Font font, Bean<Configuration> bean) {
        this.ui = userInterfaceImpl;
        this.redrawThread = redrawThread;
        this.diagramStack = new LinkedList();
        this.textArea = new TextArea();
        this.textArea.setFont(font);
        this.textArea.getDocument().addDocumentListener(this);
        this.textArea.setMinimumSize(new Dimension(100, 100));
        this.ppdListeners = new LinkedList<PanelPaintDeviceListener>();
        new AutoCompletion(this.textArea, this, '=', ':', '>');
        this.menu = this.createPopupMenu();
        this.zoomPane = new ZoomPane();
        this.zoomPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (Tab.this.getDiagram() != null && mouseEvent.getButton() == 3) {
                    Tab.this.menu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                    mouseEvent.consume();
                    return;
                }
            }
        });
        this.filterField = new FilterCommandField(userInterfaceImpl);
        this.filterMode = false;
        this.textScroller = new JScrollPane();
        this.textScroller.getVerticalScrollBar().setUnitIncrement(30);
        this.setLineWrap(bean.getDataObject().isLineWrap());
        this.splitter = new JSplitPane(0, this.zoomPane, this.textScroller);
        this.splitter.setOneTouchExpandable(true);
        this.splitter.setResizeWeight(0.8);
        this.setLayout(new BorderLayout());
        this.stainedListeners = new LinkedList<StainedListener>();
        this.add((Component)this.splitter, "Center");
        this.errorCharIndex = -1;
        this.code = "";
        this.errorLabel = new JLabel("");
        this.statusLabel = new JLabel("");
        this.errorLabel.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                if (Tab.this.errorCharIndex > -1) {
                    Tab.this.errorLabel.setCursor(Constants.HAND_CURSOR);
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                Tab.this.errorLabel.setCursor(Cursor.getDefaultCursor());
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (Tab.this.errorCharIndex > -1) {
                    Tab.this.moveCursorToPosition(Tab.this.errorCharIndex);
                }
            }
        });
        this.bottom = new JPanel();
        this.bottom.setLayout(new BorderLayout());
        this.add((Component)this.bottom, "South");
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BorderLayout());
        this.bottomPanel.add((Component)this.errorLabel, "Center");
        this.bottomPanel.add((Component)this.statusLabel, "East");
        this.bottomPanel.setPreferredSize(new Dimension(Integer.MAX_VALUE, 20));
        this.bottom.add((Component)this.bottomPanel, "Center");
        LookAndFeelManager.instance().registerOrphan(this);
        LookAndFeelManager.instance().registerOrphan(this.filterField);
        this.configuration = bean;
        bean.addPropertyChangeListener(this);
        this.setClean();
    }

    void addPanelPaintDeviceListener(PanelPaintDeviceListener panelPaintDeviceListener) {
        this.ppdListeners.add(panelPaintDeviceListener);
    }

    private void setLineWrap(boolean bl) {
        if (bl) {
            this.textScroller.setViewportView(this.textArea);
        } else {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(this.textArea);
            this.textScroller.setViewportView(jPanel);
        }
    }

    private void somethingChanged() {
        this.redrawThread.indicateChange();
        this.timeOfLastKeyChange = System.currentTimeMillis();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean bl;
                boolean bl2 = bl = Tab.this.textArea.getText().length() != Tab.this.code.length() || !Tab.this.textArea.getText().equals(Tab.this.code) || !Tab.this.oldConfiguration.equals(Tab.this.configuration);
                if (Tab.this.stained != bl) {
                    Tab.this.fireStainedStatusChanged(bl);
                    Tab.this.stained = bl;
                }
                Tab.this.ui.enableComponents();
            }
        });
    }

    synchronized DiagramError getDiagramError() {
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renderDiagram() {
        PanelPaintDevice panelPaintDevice = new PanelPaintDevice(true);
        for (PanelPaintDeviceListener object2 : this.ppdListeners) {
            panelPaintDevice.addListener(object2);
        }
        TextHandler textHandler = new TextHandler(this.getCode());
        Diagram diagram = new Diagram(this.configuration.getDataObject(), textHandler, panelPaintDevice);
        DiagramError diagramError = null;
        try {
            diagram.generate();
        }
        catch (RuntimeException diagramError2) {
            diagramError = new FatalError((DiagramDataProvider)textHandler, diagramError2);
        }
        catch (DiagramError linkedList) {
            diagramError = linkedList;
        }
        LinkedList<Diagram> linkedList = this.diagramStack;
        synchronized (linkedList) {
            this.diagramStack.addLast(diagram);
            Tab tab = this;
            synchronized (tab) {
                this.error = diagramError;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Diagram getDiagram() {
        LinkedList<Diagram> linkedList = this.diagramStack;
        synchronized (linkedList) {
            switch (this.diagramStack.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return this.diagramStack.getLast();
                }
            }
            Diagram diagram = this.diagramStack.getLast();
            this.diagramStack.clear();
            this.diagramStack.addLast(diagram);
            return diagram;
        }
    }

    @Override
    public void addStainedListener(StainedListener stainedListener) {
        this.stainedListeners.add(stainedListener);
    }

    void layout(int n) {
        this.remove(this.splitter);
        switch (n) {
            case 0: {
                this.splitter = new JSplitPane(1, this.textScroller, this.zoomPane);
                this.splitter.setResizeWeight(0.2);
                break;
            }
            case 1: {
                this.splitter = new JSplitPane(0, this.zoomPane, this.textScroller);
                this.splitter.setOneTouchExpandable(true);
                this.splitter.setResizeWeight(0.8);
                break;
            }
            default: {
                throw new IllegalArgumentException("layout " + n + " not supported");
            }
        }
        this.splitter.setOneTouchExpandable(true);
        this.add((Component)this.splitter, "Center");
        this.revalidate();
        this.configuration.getDataObject().setVerticallySplit(n == 1);
        this.ui.enableComponents();
    }

    TextArea getTextArea() {
        return this.textArea;
    }

    boolean isClean() {
        return !this.stained;
    }

    void setFile(File file) {
        this.file = file;
    }

    File getFile() {
        return this.file;
    }

    ZoomPane getZoomPane() {
        return this.zoomPane;
    }

    void setClean() {
        boolean bl = this.stained;
        this.code = this.textArea.getText();
        this.stained = false;
        this.oldConfiguration = this.configuration.copy();
        if (bl) {
            this.fireStainedStatusChanged(false);
        }
    }

    private void fireStainedStatusChanged(boolean bl) {
        for (StainedListener stainedListener : this.stainedListeners) {
            stainedListener.stainedStatusChanged(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        LinkedList<Diagram> linkedList = this.diagramStack;
        synchronized (linkedList) {
            this.diagramStack.clear();
        }
        this.redraw();
    }

    void home() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Tab.this.zoomPane.home();
            }
        });
    }

    String getCode() {
        return this.textArea.getText();
    }

    void setCode(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.textArea.setText(string);
            this.setClean();
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Tab.this.textArea.setText(string);
                Tab.this.setClean();
            }
        });
    }

    void redraw() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Diagram diagram = Tab.this.getDiagram();
                if (diagram != null) {
                    Tab.this.zoomPane.setViewportView(((PanelPaintDevice)diagram.getPaintDevice()).getPanel());
                    if (ConfigurationManager.getGlobalConfiguration().isAutoScroll() && System.currentTimeMillis() - Tab.this.timeOfLastKeyChange <= 500L) {
                        Tab.this.scrollToCurrentDrawable();
                    }
                } else {
                    Tab.this.zoomPane.setViewportView(null);
                }
                Tab.this.ui.enableComponents();
            }
        });
    }

    void moveCursorToPosition(int n) {
        this.textArea.requestFocusInWindow();
        this.textArea.setCaretPosition(n);
    }

    void undo() {
        this.textArea.undo();
    }

    void redo() {
        this.textArea.redo();
    }

    void enterFilterMode() {
        if (this.filterMode) {
            return;
        }
        this.filterMode = true;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Tab.this.filterField.reset();
                Tab.this.bottom.remove(Tab.this.bottomPanel);
                Tab.this.bottom.add((Component)Tab.this.filterField, "Center");
                Tab.this.bottom.revalidate();
                Tab.this.filterField.requestFocus();
            }
        });
    }

    void toggleFilterMode() {
        if (this.filterMode) {
            this.leaveFilterMode();
        } else {
            this.enterFilterMode();
        }
    }

    void leaveFilterMode() {
        if (!this.filterMode) {
            return;
        }
        this.filterMode = false;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Tab.this.filterField.reset();
                Tab.this.bottom.remove(Tab.this.filterField);
                Tab.this.bottom.add((Component)Tab.this.bottomPanel, "Center");
                Tab.this.bottom.revalidate();
            }
        });
    }

    private void scrollToCurrentDrawable() {
        int n = this.textArea.getCurrentLineBegin();
        Diagram diagram = this.getDiagram();
        if (diagram != null) {
            PanelPaintDevice panelPaintDevice = (PanelPaintDevice)diagram.getPaintDevice();
            Drawable drawable = diagram.getDrawableForState(n);
            if (drawable instanceof Arrow) {
                Arrow arrow = (Arrow)drawable;
                Point point = arrow.getTextPosition();
                int n2 = point != null ? point.x : arrow.getLeft();
                float f = 1.0f * (float)n2 / (float)panelPaintDevice.getWidth();
                int n3 = drawable.getTop();
                float f2 = 1.0f * (float)n3 / (float)panelPaintDevice.getHeight();
                this.zoomPane.scrollToPosition(f, f2);
            } else if (drawable != null) {
                int n4 = drawable.getLeft();
                float f = 1.0f * (float)n4 / (float)panelPaintDevice.getWidth();
                int n5 = drawable.getTop();
                float f3 = 1.0f * (float)n5 / (float)panelPaintDevice.getHeight();
                this.zoomPane.scrollToPosition(f, f3);
            } else {
                int n6 = this.textArea.getCaretPosition();
                if (this.textArea.getText().substring(n6).trim().length() == 0) {
                    this.zoomPane.scrollToBottom();
                }
            }
        }
    }

    void append(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.textArea.setText(this.textArea.getText() + string);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Tab.this.textArea.setText(Tab.this.textArea.getText() + string);
                }
            });
        }
    }

    void setStatus(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Tab.this.statusLabel.setText(string + "    ");
            }
        });
    }

    void setError(final boolean bl, final String string, final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (bl) {
                    Tab.this.errorLabel.setForeground(Color.ORANGE);
                } else {
                    Tab.this.errorLabel.setForeground(Color.RED);
                }
                Tab.this.errorLabel.setText(string);
                Tab.this.errorCharIndex = n;
                Tab.this.textArea.markError(n, n2);
            }
        });
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        AbstractAction abstractAction = new AbstractAction(){
            {
                this.putValue("Name", "Fit size");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Tab.this.zoomPane.fitSize();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){
            {
                this.putValue("Name", "100 %");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Tab.this.zoomPane.setScale(1.0);
            }
        };
        jPopupMenu.add(abstractAction);
        jPopupMenu.add(abstractAction2);
        return jPopupMenu;
    }

    @Override
    public List<String> getSuggestions(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        Diagram diagram = this.getDiagram();
        if (diagram != null) {
            for (Lifeline lifeline : diagram.getAllLifelines()) {
                String string2 = lifeline.getName();
                if (!string2.startsWith(string)) continue;
                linkedList.add(string2);
            }
        }
        return linkedList;
    }

    Bean<Configuration> getConfiguration() {
        return this.configuration;
    }

    void setConfiguration(Bean<Configuration> bean) {
        if (bean != null) {
            this.configuration.removePropertyChangeListener(this);
        }
        this.configuration = bean;
        this.configuration.addPropertyChangeListener(this);
        this.oldConfiguration = bean;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.somethingChanged();
        if (propertyChangeEvent.getPropertyName().toLowerCase().equals("linewrap")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.setLineWrap(bl);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.somethingChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.somethingChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.somethingChanged();
    }
}

