/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.config.ConfigurationManager;
import net.sf.sdedit.config.PrintConfiguration;
import net.sf.sdedit.error.SemanticError;
import net.sf.sdedit.error.SyntaxError;
import net.sf.sdedit.multipage.MultipageExporter;
import net.sf.sdedit.ui.components.ButtonPanel;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.ConfigurationDialog;
import net.sf.sdedit.ui.components.configuration.ConfigurationUI;
import net.sf.sdedit.ui.impl.UserInterfaceImpl;
import net.sf.sdedit.util.UIUtilities;

public class PrintDialog
extends ConfigurationDialog
implements PropertyChangeListener {
    private String fileType;
    private UserInterfaceImpl ui;
    private JScrollPane preview;
    private MultipageExporter exporter;
    private Bean<PrintConfiguration> printerProperties;
    private Bean<PrintConfiguration> copy;
    private JLabel scaleLabel;
    private Action cancel = new AbstractAction(){
        {
            this.putValue("Name", "Cancel");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PrintDialog.this.printerProperties.takeValuesFrom(PrintDialog.this.copy);
            PrintDialog.this.setVisible(false);
        }
    };
    private Action ok = new AbstractAction(){
        {
            this.putValue("Name", "OK");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ((PrintConfiguration)PrintDialog.this.printerProperties.getDataObject()).getAction();
            if (string.equals("Export file")) {
                PrintDialog.this.export();
            } else if (string.equals("Export and print")) {
                PrintDialog.this.exportAndPrint();
            } else {
                PrintDialog.this.pipe();
            }
            PrintDialog.this.setVisible(false);
        }
    };

    public PrintDialog(UserInterfaceImpl userInterfaceImpl) {
        super(userInterfaceImpl);
        this.ui = userInterfaceImpl;
        this.setModal(true);
        this.init();
    }

    private void init() {
        JPanel jPanel = new JPanel();
        this.getContentPane().add((Component)jPanel, "Center");
        ButtonPanel buttonPanel = new ButtonPanel();
        buttonPanel.addAction(this.cancel);
        buttonPanel.addAction(this.ok, 0, true);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.printerProperties = ConfigurationManager.getPrintConfigurationBean();
        this.setToCurrentFile();
        ConfigurationUI<PrintConfiguration> configurationUI = new ConfigurationUI<PrintConfiguration>(this, this.printerProperties, null, null, null, null);
        configurationUI.hideButtons();
        configurationUI.hideCategoryList();
        this.printerProperties.addPropertyChangeListener(this);
        jPanel.setLayout(new GridLayout(1, 2));
        jPanel.add(configurationUI);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new TitledBorder("Preview"));
        jPanel2.setLayout(new BorderLayout());
        this.preview = new JScrollPane();
        jPanel2.add(this.preview);
        this.scaleLabel = new JLabel("Zoom factor: 100 %");
        this.scaleLabel.setHorizontalAlignment(0);
        jPanel2.add((Component)this.scaleLabel, "South");
        jPanel.add(jPanel2);
    }

    public void show(String string) {
        this.fileType = string.toLowerCase();
        this.setTitle("Print or export multi-page " + string.toUpperCase() + " document");
        this.setSize(new Dimension(740, 540));
        UIUtilities.centerWindow(this, this.ui);
        this.reinitialize();
        this.copy = this.printerProperties.copy();
        this.setVisible(true);
    }

    private void setToCurrentFile() {
        File file = this.ui.getCurrentFile();
        if (file != null) {
            String string = file.getAbsolutePath();
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            this.printerProperties.getDataObject().setExportFile(new File(string + ".pdf"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File export() {
        File file;
        File file2 = this.printerProperties.getDataObject().getExportFile();
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(file2);
                this.exporter.exportTo(new FileOutputStream(file2), this.fileType);
                file = file2;
                Object var6_5 = null;
                if (fileOutputStream == null) return file;
            }
            catch (IOException iOException) {
                this.ui.errorMessage("Cannot export to file " + file2.getAbsolutePath() + "\ndue to an exception of type " + iOException.getClass().getSimpleName() + "\nwith the message: " + iOException.getMessage());
                File file3 = null;
                Object var6_6 = null;
                if (fileOutputStream == null) return file3;
                try {
                    ((OutputStream)fileOutputStream).close();
                    return file3;
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                return file3;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (fileOutputStream == null) throw throwable;
            try {}
            catch (IOException iOException2) {
                throw throwable;
            }
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return file;
        }
        ((OutputStream)fileOutputStream).close();
        return file;
    }

    private void exportAndPrint() {
        File file = this.export();
        if (file != null) {
            String string = this.printerProperties.getDataObject().getCommand() + " " + file.getAbsolutePath();
            try {
                Process process = Runtime.getRuntime().exec(string);
                process.waitFor();
                if (this.printerProperties.getDataObject().isEraseExportFile()) {
                    file.delete();
                }
            }
            catch (IOException iOException) {
                this.ui.errorMessage("Invocation of\n" + string + "\nfailed due to an exception of type " + iOException.getClass().getSimpleName() + "\n" + "with the message: " + iOException.getMessage());
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void pipe() {
        OutputStream outputStream = null;
        Process process = Runtime.getRuntime().exec(this.printerProperties.getDataObject().getCommand());
        outputStream = new BufferedOutputStream(process.getOutputStream());
        this.exporter.exportTo(outputStream, this.fileType);
        Object var4_4 = null;
        if (outputStream == null) return;
        try {
            outputStream.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                this.ui.errorMessage("Piping to printer command failed due to an exception of type\n" + iOException.getClass().getSimpleName() + " with the message: " + iOException.getMessage());
                Object var4_5 = null;
                if (outputStream == null) return;
                try {
                    outputStream.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (outputStream == null) throw throwable;
            try {
                outputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void reinitialize() {
        String string = this.ui.getCode();
        Configuration configuration = this.ui.getConfiguration().getDataObject();
        this.exporter = new MultipageExporter(this.printerProperties.getDataObject(), string, configuration);
        try {
            this.exporter.init();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (SemanticError semanticError) {
        }
        catch (SyntaxError syntaxError) {
            // empty catch block
        }
        int n = (int)(100.0 * this.exporter.getScale());
        this.scaleLabel.setText("Zoom factor: " + n + " %");
        this.preview.setViewportView(this.exporter);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (!(string.equals("command") || string.equals("exportFile") || string.equals("commandFile"))) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PrintDialog.this.reinitialize();
                }
            });
        }
        if (string.equals("command")) {
            PrintConfiguration printConfiguration = this.printerProperties.getDataObject();
            String string2 = printConfiguration.getAction();
            if (string2.equals("Export and print")) {
                printConfiguration.setExportFile(new File(System.getProperty("java.io.tmpdir"), "temp.pdf"));
            } else if (string2.equals("Export file")) {
                this.setToCurrentFile();
            }
        }
    }
}

