/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.impl;

import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class LookAndFeelManager
extends URLClassLoader {
    private Map<JComponent, Object> rootComponents = new WeakHashMap<JComponent, Object>();
    private Map<RootPaneContainer, Object> containers = new WeakHashMap<RootPaneContainer, Object>();
    private Map<JComponent, Object> orphans = new WeakHashMap<JComponent, Object>();
    private Object dummy = new Object();
    private static LookAndFeelManager instance = new LookAndFeelManager();
    private String currentLAF;
    private static UIManager.LookAndFeelInfo[] available = new UIManager.LookAndFeelInfo[UIManager.getInstalledLookAndFeels().length];

    public void setFont(Font font) {
        UIManager.put("Button.font", font);
        UIManager.put("ToggleButton.font", font);
        UIManager.put("RadioButton.font", font);
        UIManager.put("CheckBox.font", font);
        UIManager.put("ColorChooser.font", font);
        UIManager.put("ComboBox.font", font);
        UIManager.put("Label.font", font);
        UIManager.put("List.font", font);
        UIManager.put("MenuBar.font", font);
        UIManager.put("MenuItem.font", font);
        UIManager.put("RadioButtonMenuItem.font", font);
        UIManager.put("CheckBoxMenuItem.font", font);
        UIManager.put("Menu.font", font);
        UIManager.put("PopupMenu.font", font);
        UIManager.put("OptionPane.font", font);
        UIManager.put("Panel.font", font);
        UIManager.put("ProgressBar.font", font);
        UIManager.put("ScrollPane.font", font);
        UIManager.put("Viewport.font", font);
        UIManager.put("TabbedPane.font", font);
        UIManager.put("Table.font", font);
        UIManager.put("TableHeader.font", font);
        UIManager.put("TextField.font", font);
        UIManager.put("PasswordField.font", font);
        UIManager.put("TextArea.font", font);
        UIManager.put("TextPane.font", font);
        UIManager.put("EditorPane.font", font);
        UIManager.put("TitledBorder.font", font);
        UIManager.put("ToolBar.font", font);
        UIManager.put("ToolTip.font", font);
        UIManager.put("Tree.font", font);
    }

    private LookAndFeelManager() {
        super(new URL[0], Thread.currentThread().getContextClassLoader());
    }

    public static UIManager.LookAndFeelInfo[] getAvailableLookAndFeels() {
        return available;
    }

    public static LookAndFeelManager instance() {
        return instance;
    }

    public void useExternalLAF(File file, String string) throws MalformedURLException, ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        this.addURL(file.toURI().toURL());
        Class<?> clazz = this.loadClass(string, true);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this);
        UIManager.installLookAndFeel(clazz.getSimpleName(), string);
        UIManager.setLookAndFeel(string);
    }

    public void register(RootPaneContainer rootPaneContainer) {
        this.containers.put(rootPaneContainer, rootPaneContainer);
    }

    private void collectFrom(RootPaneContainer rootPaneContainer) {
        this.rootComponents.put((JComponent)rootPaneContainer.getGlassPane(), this.dummy);
        this.rootComponents.put(rootPaneContainer.getRootPane(), this.dummy);
        this.rootComponents.put(rootPaneContainer.getLayeredPane(), this.dummy);
        this.rootComponents.put((JComponent)rootPaneContainer.getContentPane(), this.dummy);
        this.rootComponents.put(rootPaneContainer.getRootPane().getJMenuBar(), this.dummy);
        if (rootPaneContainer.getRootPane().getJMenuBar() != null) {
            this.rootComponents.put(rootPaneContainer.getRootPane().getJMenuBar(), this.dummy);
        }
    }

    public void updateUserInterface() {
        this.rootComponents.clear();
        for (RootPaneContainer object : this.containers.keySet()) {
            this.collectFrom(object);
        }
        for (JComponent jComponent : this.rootComponents.keySet()) {
            if (jComponent == null) continue;
            SwingUtilities.updateComponentTreeUI(jComponent);
        }
        for (JComponent jComponent : this.orphans.keySet()) {
            SwingUtilities.updateComponentTreeUI(jComponent);
        }
    }

    public void registerOrphan(JComponent jComponent) {
        this.orphans.put(jComponent, this.dummy);
    }

    public boolean changeTo(String string) {
        this.currentLAF = string;
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : available) {
            if (!lookAndFeelInfo.getName().equals(string)) continue;
            try {
                UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                this.updateUserInterface();
                return true;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("lookAndFeel")) {
            String string = (String)propertyChangeEvent.getNewValue();
            if (this.currentLAF == null || !string.equals(this.currentLAF)) {
                this.changeTo(string);
            }
        }
    }

    static {
        int n = 0;
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n2 = lookAndFeelInfoArray.length;
        for (int i = 0; i < n2; ++i) {
            UIManager.LookAndFeelInfo lookAndFeelInfo;
            LookAndFeelManager.available[n] = lookAndFeelInfo = lookAndFeelInfoArray[i];
            ++n;
        }
    }
}

