/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.impl;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.sf.sdedit.ui.components.TextArea;
import net.sf.sdedit.ui.impl.Tab;
import net.sf.sdedit.ui.impl.UserInterfaceImpl;

public class FilterCommandField
extends JTextField
implements ActionListener,
KeyListener,
Runnable {
    private UserInterfaceImpl ui;
    private ArrayList<String> history;
    private int historyPointer;
    private String currentText;
    private String homeDir;
    private boolean first;
    private Process process;
    private String text;
    private boolean selection;
    private TextArea textArea;
    private Tab tab;

    public FilterCommandField(UserInterfaceImpl userInterfaceImpl) {
        this.ui = userInterfaceImpl;
        this.addActionListener(this);
        this.addKeyListener(this);
        this.history = new ArrayList();
        this.historyPointer = 0;
        this.currentText = null;
        this.homeDir = System.getProperty("user.home");
        this.first = true;
    }

    public void reset() {
        this.currentText = null;
        if (this.first) {
            this.setText("<enter filter command>");
            this.selectAll();
            this.first = false;
        } else {
            this.setText("");
        }
        this.historyPointer = this.history.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String string) throws IOException {
        this.history.add(string);
        if (this.homeDir != null && !this.homeDir.equals("")) {
            string = string.replaceAll("~", this.homeDir);
        }
        this.selection = true;
        this.tab = this.ui.currentTab();
        if (this.tab == null) {
            return;
        }
        this.textArea = this.tab.getTextArea();
        this.text = this.tab.getTextArea().getSelectedText();
        if (this.text == null) {
            this.selection = false;
            this.text = this.tab.getTextArea().getText();
        }
        FilterCommandField filterCommandField = this;
        synchronized (filterCommandField) {
            this.process = Runtime.getRuntime().exec(string);
            this.changeBackground(Color.RED);
        }
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        FilterCommandField filterCommandField;
        try {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new BufferedOutputStream(this.process.getOutputStream()));
                PrintWriter printWriter = new PrintWriter(outputStreamWriter);
                printWriter.print(this.text);
                printWriter.flush();
                printWriter.close();
                StringBuffer stringBuffer = new StringBuffer();
                String string = bufferedReader.readLine();
                while (string != null) {
                    stringBuffer.append(string + "\n");
                    string = bufferedReader.readLine();
                }
                StringBuffer stringBuffer2 = new StringBuffer();
                string = bufferedReader2.readLine();
                while (string != null) {
                    stringBuffer2.append(string + "\n");
                    string = bufferedReader2.readLine();
                }
                bufferedReader.close();
                bufferedReader2.close();
                final String string2 = stringBuffer.toString().trim();
                String string3 = stringBuffer2.toString().trim();
                if (!string3.equals("")) {
                    this.ui.errorMessage("The filter command returned an error:\n" + string3);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (FilterCommandField.this.selection) {
                            FilterCommandField.this.textArea.replaceSelection(string2);
                        } else {
                            FilterCommandField.this.textArea.setText(string2);
                        }
                    }
                });
            }
            catch (IOException iOException) {
                FilterCommandField filterCommandField3 = this;
                synchronized (filterCommandField3) {
                    if (this.process != null) {
                        this.ui.errorMessage("An exception of type " + iOException.getClass().getSimpleName() + "has occured with the message:\n" + iOException.getMessage());
                    }
                }
                Object var12_13 = null;
                FilterCommandField filterCommandField4 = this;
                synchronized (filterCommandField4) {
                    this.process = null;
                    this.changeBackground(Color.WHITE);
                }
                this.ui.leaveFilterMode();
                return;
            }
            Object var12_12 = null;
            filterCommandField = this;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            FilterCommandField filterCommandField2 = this;
            synchronized (filterCommandField2) {
                this.process = null;
                this.changeBackground(Color.WHITE);
            }
            this.ui.leaveFilterMode();
            throw throwable;
        }
        synchronized (filterCommandField) {
            this.process = null;
            this.changeBackground(Color.WHITE);
        }
        this.ui.leaveFilterMode();
    }

    private void changeBackground(final Color color) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FilterCommandField.this.setBackground(color);
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.process != null) {
            return;
        }
        String string = this.getText().trim();
        if (string.equals("")) {
            return;
        }
        try {
            this.execute(string);
        }
        catch (IOException iOException) {
            this.ui.errorMessage("An exception of type " + iOException.getClass().getSimpleName() + " has occured with the message:\n" + iOException.getMessage());
        }
    }

    private void useHistory(int n) {
        if (this.historyPointer == this.history.size() && n > 0) {
            return;
        }
        if (this.historyPointer == 0 && n < 0) {
            return;
        }
        this.historyPointer += n;
        if (this.historyPointer == this.history.size()) {
            this.setText(this.currentText);
            this.currentText = null;
        } else {
            if (this.currentText == null) {
                this.currentText = this.getText();
            }
            this.setText(this.history.get(this.historyPointer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 38) {
            this.useHistory(-1);
        } else if (keyEvent.getKeyCode() == 40) {
            this.useHistory(1);
        } else if (keyEvent.getKeyCode() == 27) {
            FilterCommandField filterCommandField = this;
            synchronized (filterCommandField) {
                if (this.process != null) {
                    this.process.destroy();
                    this.process = null;
                } else {
                    this.ui.leaveFilterMode();
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

