/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration.configurators;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyDescriptor;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import net.sf.sdedit.ui.components.configuration.Adjustable;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.DataObject;
import net.sf.sdedit.ui.components.configuration.configurators.StringConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmallStringSelectionConfigurator<C extends DataObject>
extends StringConfigurator<C>
implements ActionListener {
    private static final long serialVersionUID = 8434413547241922267L;
    private ButtonGroup buttonGroup;

    public SmallStringSelectionConfigurator(Bean<C> bean, PropertyDescriptor propertyDescriptor) {
        super(bean, propertyDescriptor);
        this.initialize();
    }

    private void initialize() {
        String[] stringArray = this.getProperty().getWriteMethod().getAnnotation(Adjustable.class).choices();
        this.getBottomPanel().setLayout(new FlowLayout(3));
        this.buttonGroup = new ButtonGroup();
        for (String string : stringArray) {
            JRadioButton jRadioButton = new JRadioButton(string);
            this.buttonGroup.add(jRadioButton);
            this.getBottomPanel().add(jRadioButton);
            jRadioButton.addActionListener(this);
        }
    }

    @Override
    protected void refresh(String string) {
        for (JRadioButton jRadioButton : this.getButtons()) {
            if (!jRadioButton.getText().equals(string)) continue;
            jRadioButton.setSelected(true);
            return;
        }
    }

    @Override
    protected void _actionPerformed(ActionEvent actionEvent) {
        JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
        this.applyValue(jRadioButton.getText());
    }

    private List<JRadioButton> getButtons() {
        LinkedList<JRadioButton> linkedList = new LinkedList<JRadioButton>();
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            linkedList.add(jRadioButton);
        }
        return linkedList;
    }

    @Override
    protected void _setEnabled(boolean bl) {
        for (JRadioButton jRadioButton : this.getButtons()) {
            jRadioButton.setEnabled(bl);
        }
    }
}

