/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration.configurators;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyDescriptor;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.sdedit.ui.components.configuration.Adjustable;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.Configurator;
import net.sf.sdedit.ui.components.configuration.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberConfigurator<C extends DataObject>
extends Configurator<Integer, C>
implements ChangeListener {
    private JSpinner spinner;
    private int min;
    private int max;
    private JLabel label;

    public NumberConfigurator(Bean<C> bean, PropertyDescriptor propertyDescriptor) {
        super(bean, propertyDescriptor);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        Adjustable adjustable = this.getProperty().getWriteMethod().getAnnotation(Adjustable.class);
        this.min = adjustable.min();
        this.max = adjustable.max();
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(adjustable.min(), adjustable.min(), adjustable.max(), adjustable.step());
        this.spinner = new JSpinner(spinnerNumberModel);
        this.spinner.setPreferredSize(new Dimension(45, 1));
        this.spinner.addChangeListener(this);
        this.label = new JLabel(adjustable.info());
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.add((Component)this.spinner, "West");
        this.add((Component)this.label, "Center");
    }

    @Override
    protected void refresh(Integer n) {
        if (n < this.min) {
            n = this.min;
        } else if (n > this.max) {
            n = this.max;
        }
        this.spinner.setValue(n);
    }

    @Override
    protected void _actionPerformed(ActionEvent actionEvent) {
        int n = (Integer)this.spinner.getValue();
        this.applyValue(n);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.actionPerformed(null);
    }

    @Override
    protected Integer getNullValue() {
        return this.getProperty().getWriteMethod().getAnnotation(Adjustable.class).dflt();
    }

    @Override
    protected void _setEnabled(boolean bl) {
        this.spinner.setEnabled(bl);
    }
}

