/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration.configurators;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.Timer;

public class FontPreview
implements ActionListener,
MouseListener,
MouseMotionListener {
    private Timer timer;
    private static final int delay = 500;
    private JComponent glassPane;
    private JTable table;
    private JLabel label;
    private Point position;

    public FontPreview(JDialog jDialog, JTable jTable) {
        this.glassPane = (JComponent)jDialog.getGlassPane();
        this.table = jTable;
        jTable.addMouseMotionListener(this);
        jTable.addMouseListener(this);
        this.timer = new Timer(500, this);
        this.label = new JLabel();
        this.label.setSize(140, 60);
        this.label.setOpaque(true);
        this.label.setBackground(Color.YELLOW);
        this.label.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.position = null;
        this.timer.start();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.timer.restart();
        this.hideLabel();
        this.position = mouseEvent.getPoint();
    }

    private void hideLabel() {
        this.label.setVisible(false);
        this.glassPane.remove(this.label);
        this.glassPane.revalidate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.position == null) {
            return;
        }
        int n = this.table.rowAtPoint(this.position);
        if (n == -1) {
            return;
        }
        String string = (String)this.table.getValueAt(n, 0);
        Font font = new Font(string, 0, 14);
        this.label.setText("");
        this.label.setFont(font);
        this.label.setText("<html><center>&nbsp;<u>" + string + "</u>&nbsp;<br>&nbsp;The quick brown&nbsp;<br>&nbsp;fox jumps over&nbsp;<br>&nbsp;the lazy dog.");
        this.label.setSize(this.label.getPreferredSize());
        int n2 = this.glassPane.getWidth() / 2 - this.label.getWidth() / 2;
        int n3 = this.glassPane.getHeight() / 2 - this.label.getHeight() / 2;
        this.label.setLocation(n2, n3);
        this.glassPane.add(this.label);
        this.label.setVisible(true);
        this.glassPane.updateUI();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.timer.restart();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.timer.stop();
        this.hideLabel();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }
}

