/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration.configurators;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyDescriptor;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.sdedit.ui.components.configuration.Adjustable;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.Configurator;
import net.sf.sdedit.ui.components.configuration.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontConfigurator<C extends DataObject>
extends Configurator<Font, C>
implements ActionListener,
ChangeListener {
    private static final int strut = 5;
    private JComboBox nameComboBox;
    private JSpinner sizeSpinner;
    private JCheckBox italic;
    private JCheckBox bold;
    private JLabel sampleLabel;
    private JLabel label;

    public FontConfigurator(Bean<C> bean, PropertyDescriptor propertyDescriptor) {
        super(bean, propertyDescriptor);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridLayout(2, 1));
        JPanel jPanel = new JPanel();
        this.add(jPanel);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.label = new JLabel(this.getProperty().getWriteMethod().getAnnotation(Adjustable.class).info() + ":");
        this.label.setHorizontalAlignment(11);
        this.label.setPreferredSize(new Dimension(90, this.label.getPreferredSize().height));
        this.label.setHorizontalAlignment(4);
        jPanel.add(this.label);
        jPanel.add(Box.createRigidArea(new Dimension(5, 1)));
        this.nameComboBox = new JComboBox<String>(FontConfigurator.getAllFontFamilyNames());
        jPanel.add(this.nameComboBox);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(12, 1, 128, 1);
        this.sizeSpinner = new JSpinner(spinnerNumberModel);
        jPanel.add(Box.createRigidArea(new Dimension(5, 1)));
        jPanel.add(this.sizeSpinner);
        jPanel.add(Box.createRigidArea(new Dimension(5, 1)));
        this.italic = new JCheckBox("italic");
        this.bold = new JCheckBox("bold");
        jPanel.add(this.italic);
        jPanel.add(this.bold);
        this.sampleLabel = new JLabel();
        this.add(this.sampleLabel);
        this.sizeSpinner.addChangeListener(this);
        this.nameComboBox.addActionListener(this);
        this.italic.addActionListener(this);
        this.bold.addActionListener(this);
    }

    private static String[] getAllFontFamilyNames() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return graphicsEnvironment.getAvailableFontFamilyNames();
    }

    @Override
    protected void refresh(Font font) {
        this.nameComboBox.setSelectedItem(font.getFamily());
        this.sizeSpinner.setValue(font.getSize());
        this.italic.setSelected(false);
        this.bold.setSelected(false);
        switch (font.getStyle()) {
            case 1: {
                this.bold.setSelected(true);
                break;
            }
            case 2: {
                this.italic.setSelected(true);
                break;
            }
            case 3: {
                this.italic.setSelected(true);
                this.bold.setSelected(true);
            }
        }
        this.sampleLabel.setFont(this.getSelectedFont());
        this.sampleLabel.setText("The quick brown fox jumps over the lazy dog.");
    }

    @Override
    protected Font getNullValue() {
        return new Font("Dialog", 0, 12);
    }

    private Font getSelectedFont() {
        String string = (String)this.nameComboBox.getSelectedItem();
        int n = (Integer)this.sizeSpinner.getValue();
        int n2 = (this.bold.isSelected() ? 1 : 0) + (this.italic.isSelected() ? 2 : 0);
        Font font = new Font(string, n2, n);
        return font;
    }

    @Override
    public void _actionPerformed(ActionEvent actionEvent) {
        Font font = this.getSelectedFont();
        this.applyValue(font);
        this.sampleLabel.setFont(font);
        this.sampleLabel.setText("The quick brown fox jumps over the lazy dog.");
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.actionPerformed(null);
    }

    @Override
    protected void _setEnabled(boolean bl) {
        this.nameComboBox.setEnabled(bl);
        this.sizeSpinner.setEnabled(bl);
        this.italic.setEnabled(bl);
        this.bold.setEnabled(bl);
        this.label.setEnabled(bl);
        this.sampleLabel.setEnabled(bl);
    }

    @Override
    public int getLabelWidth() {
        return this.label.getPreferredSize().width;
    }

    @Override
    public void setLabelWidth(int n) {
        this.label.setPreferredSize(new Dimension(n, this.label.getPreferredSize().height));
    }
}

