/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration.configurators;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyDescriptor;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.Configurator;
import net.sf.sdedit.ui.components.configuration.DataObject;
import net.sf.sdedit.util.base64.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileConfigurator<C extends DataObject>
extends Configurator<File, C>
implements FocusListener {
    private JTextField fileTextField;
    private JButton browseButton;
    private JLabel label;
    private String description;
    private JFileChooser fileChooser;
    private static ImageIcon openIcon = new ImageIcon(Base64.decodeBase64EncodedImage("iVBORw0KGgoAAAANSUhEUgAAAA8AAAAPCAYAAAA71pVKAAAABGdBTUEAAK/INwWK6QAAAAZiS0dEAP8A/wD/oL2nkwAAAAlwSFlzAAAASAAAAEgARslrPgAAAsBJREFUKM+ljU1oHFUAgL83M7ub/ckmWU2KuqbVdtvYSH8oBQUpgaKHiicPikgvgohabxYKPffmScGbBfGqeLCh6EGprZSaFlFTY6KbzW5S26ab/Zt5M+/Nm/e8eRA8+V0/Pj74H4j/Evuf/YzVlQfi7JlnnqpU8q/p1HxxYF/t1jffbfDpxycBCP4dvXv2CuVykcFQTr31+uGX9z05+d7ux8efvnHr3vyXl5pvzEyXdv45L5xvfXT8YJUkdYSJ9a7c6C6/uje8Pt+Yev9Ao/bSbL1SwsFacxB//lXz3AcXVj48dXraLl4cJ5h7YuydkyeqyBT6vZS5momOzkwMjs5P7SoVC75SFq0zZh+rFI8cmjnz/Cvxb5c+OfF1o/MtwVheMFn10VuSR3TMwvFKebZeLntCoBT4nkCljptrkgeJv1eUi29PPHc1H0vPBJl1WOuIthNmqwG58hib3ZTMgNaQJBmXlwasdgXVyUl2H6ucKtbVoR+/b4+CzIJ18NNdWGkl7NnxiY0lUQ6ZWAajjGFawJ+e4PeBRzxUuZ+v3Xu034kXA2sd/VFGv6d584Ua+ZJH5Pus33U07zgi7diJoP2L5H6rx05zOBje70sXpFcDa2Hlz4S5+hiVmRy3O4Z+DGttQXPDsN5Jabci+n8Nibsh9FREYDYJzJIXK0urLZlvFNkYCbYin/UtSxRZVGIZDTVhmOIE5Au+8/OugDAtrF0OVlsJC0eq7HkoQARQ2yXo5SxhaOiOa449nBIeBC0FSeiJ23+I4rUls1wq5bpBZ1Ny+MUajZoPgKsIVM1DRiDrIKWPjDKkDJBxgV4YJpmzP+RyHgHKcGdbs3i9j8nAWUeSZESRQkqNlAoZKZJYI+OUm7/Ktt00S10BwUhmpy9e3sYXYI0jyywmzUh1itGGVKek2mB0hlJGqJ5rU/JGLrb8DdKwhwGMgWXLAAAAInpUWHRTb2Z0d2FyZQAAeNpzTMlPSlXwzE1MTw1KTUypBAAvnAXUrgypTQAAAABJRU5ErkJggg=="));

    public FileConfigurator(Bean<C> bean, PropertyDescriptor propertyDescriptor) {
        super(bean, propertyDescriptor);
        this.setLayout(new BorderLayout());
        this.description = this.getAdjustable().info();
        this.fileChooser = new JFileChooser(System.getProperty("user.home"));
        this.label = new JLabel(this.description + ":");
        this.add((Component)this.label, "West");
        this.browseButton = new JButton(openIcon);
        this.browseButton.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 1));
        this.browseButton.setOpaque(true);
        this.browseButton.setMargin(new Insets(1, 1, 1, 1));
        this.add((Component)this.browseButton, "East");
        this.fileTextField = new JTextField();
        this.fileTextField.addActionListener(this);
        this.fileTextField.addFocusListener(this);
        this.fileTextField.setText("");
        this.add((Component)this.fileTextField, "Center");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileConfigurator.this.browse();
            }
        });
        this.label.setHorizontalAlignment(4);
    }

    public void setFile(File file) {
        this.fileTextField.setText(file.getAbsolutePath());
    }

    public File getFile() {
        return new File(this.fileTextField.getText());
    }

    private void browse() {
        File file;
        int n;
        File file2 = this.getFile();
        if (file2 != null && file2.getParentFile() != null) {
            this.fileChooser.setCurrentDirectory(file2.getParentFile());
        }
        if ((n = this.fileChooser.showOpenDialog(null)) == 0 && (file = this.fileChooser.getSelectedFile()) != null) {
            this.refresh(file);
            this._actionPerformed(null);
        }
    }

    @Override
    protected void _actionPerformed(ActionEvent actionEvent) {
        String string = this.fileTextField.getText();
        if (!string.equals("")) {
            this.getBean().setValue(this.getProperty(), new File(this.fileTextField.getText()));
        }
    }

    @Override
    protected File getNullValue() {
        return new File(System.getProperty("user.home"), "untitled");
    }

    @Override
    protected void refresh(File file) {
        this.fileTextField.setText(file == null ? "" : file.getAbsolutePath());
    }

    @Override
    public int getLabelWidth() {
        return this.label.getPreferredSize().width;
    }

    @Override
    public void setLabelWidth(int n) {
        this.label.setPreferredSize(new Dimension(n, this.label.getPreferredSize().height));
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.actionPerformed(null);
    }

    @Override
    protected void _setEnabled(boolean bl) {
    }
}

