/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration.configurators;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyDescriptor;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import net.sf.sdedit.ui.components.configuration.Adjustable;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.Configurator;
import net.sf.sdedit.ui.components.configuration.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorConfigurator<C extends DataObject>
extends Configurator<Color, C> {
    private JLabel label;
    private JLabel caption;

    public ColorConfigurator(Bean<C> bean, PropertyDescriptor propertyDescriptor) {
        super(bean, propertyDescriptor);
        this.setLayout(new GridLayout(1, 2));
        final String string = propertyDescriptor.getWriteMethod().getAnnotation(Adjustable.class).info();
        this.caption = new JLabel(string);
        this.label = new JLabel();
        this.label.setOpaque(true);
        this.label.setBackground((Color)this.getValue());
        this.label.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.label.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Color color;
                if (ColorConfigurator.this.label.isEnabled() && SwingUtilities.isLeftMouseButton(mouseEvent) && (color = JColorChooser.showDialog(ColorConfigurator.this, string, (Color)ColorConfigurator.this.getValue())) != null) {
                    ActionEvent actionEvent = new ActionEvent(ColorConfigurator.this.label, 1, "" + color.getRGB());
                    ColorConfigurator.this.actionPerformed(actionEvent);
                }
            }
        });
        this.add(this.caption);
        this.add(this.label);
    }

    @Override
    protected void _actionPerformed(ActionEvent actionEvent) {
        int n = Integer.parseInt(actionEvent.getActionCommand());
        this.applyValue(new Color(n));
    }

    @Override
    protected void _setEnabled(boolean bl) {
        this.caption.setEnabled(bl);
        this.label.setEnabled(bl);
    }

    @Override
    protected Color getNullValue() {
        return Color.WHITE;
    }

    @Override
    protected void refresh(Color color) {
        this.label.setBackground(color);
    }
}

