/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyDescriptor;
import java.io.File;
import net.sf.sdedit.ui.components.configuration.Adjustable;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.Configurator;
import net.sf.sdedit.ui.components.configuration.DataObject;
import net.sf.sdedit.ui.components.configuration.configurators.BooleanConfigurator;
import net.sf.sdedit.ui.components.configuration.configurators.ColorConfigurator;
import net.sf.sdedit.ui.components.configuration.configurators.FileConfigurator;
import net.sf.sdedit.ui.components.configuration.configurators.FontConfigurator;
import net.sf.sdedit.ui.components.configuration.configurators.FreeStringConfigurator;
import net.sf.sdedit.ui.components.configuration.configurators.NumberConfigurator;
import net.sf.sdedit.ui.components.configuration.configurators.SmallStringSelectionConfigurator;
import net.sf.sdedit.ui.components.configuration.configurators.StringSelectionConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfiguratorFactory<C extends DataObject> {
    public Configurator<?, C> createConfigurator(Bean<C> bean, PropertyDescriptor propertyDescriptor, Bean<C> bean2) {
        if (propertyDescriptor.getPropertyType().equals(String.class)) {
            Adjustable adjustable = propertyDescriptor.getWriteMethod().getAnnotation(Adjustable.class);
            String[] stringArray = adjustable.choices();
            if (stringArray.length > 0) {
                if (!adjustable.forceComboBox() && stringArray.length <= 3) {
                    return new SmallStringSelectionConfigurator<C>(bean, propertyDescriptor);
                }
                return new StringSelectionConfigurator<C>(bean, propertyDescriptor);
            }
            if (!propertyDescriptor.getWriteMethod().getAnnotation(Adjustable.class).stringSelectionProvided()) {
                return new FreeStringConfigurator<C>(bean, propertyDescriptor);
            }
            return new StringSelectionConfigurator<C>(bean, propertyDescriptor);
        }
        if (propertyDescriptor.getPropertyType().equals(Integer.TYPE)) {
            return new NumberConfigurator<C>(bean, propertyDescriptor);
        }
        if (propertyDescriptor.getPropertyType().equals(Boolean.TYPE)) {
            return new BooleanConfigurator<C>(bean, propertyDescriptor);
        }
        if (propertyDescriptor.getPropertyType().equals(Font.class)) {
            return new FontConfigurator<C>(bean, propertyDescriptor);
        }
        if (propertyDescriptor.getPropertyType().equals(File.class)) {
            return new FileConfigurator<C>(bean, propertyDescriptor);
        }
        if (propertyDescriptor.getPropertyType().equals(Color.class)) {
            return new ColorConfigurator<C>(bean, propertyDescriptor);
        }
        throw new IllegalArgumentException("cannot create configurator for property type " + propertyDescriptor.getPropertyType().getSimpleName());
    }
}

