/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.sf.sdedit.ui.components.configuration.Adjustable;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Configurator<T, C extends DataObject>
extends JPanel
implements PropertyChangeListener,
ActionListener {
    private Bean<C> bean;
    private PropertyDescriptor property;
    private String[] dependentProperty;
    private String[] dependentValue;
    private boolean[] isDependencyEquality;

    protected Configurator(Bean<C> bean, PropertyDescriptor propertyDescriptor) {
        this.bean = bean;
        this.property = propertyDescriptor;
        Adjustable adjustable = propertyDescriptor.getWriteMethod().getAnnotation(Adjustable.class);
        if (!adjustable.depends().equals("")) {
            String[] stringArray = adjustable.depends().split(",");
            int n = stringArray.length;
            this.dependentProperty = new String[n];
            this.dependentValue = new String[n];
            this.isDependencyEquality = new boolean[n];
            for (int i = 0; i < n; ++i) {
                String[] stringArray2;
                String string = stringArray[i];
                if (string.indexOf(33) == -1) {
                    this.isDependencyEquality[i] = true;
                    stringArray2 = string.split("=");
                } else {
                    this.isDependencyEquality[i] = false;
                    stringArray2 = string.split("!=");
                }
                this.dependentProperty[i] = stringArray2[0];
                this.dependentValue[i] = stringArray2[1];
            }
        }
        bean.addPropertyChangeListener(this);
    }

    public int getLabelWidth() {
        return -1;
    }

    public void setLabelWidth(int n) {
    }

    protected abstract void refresh(T var1);

    protected abstract T getNullValue();

    public boolean isDependencySatisfied() {
        if (this.dependentProperty == null) {
            return true;
        }
        for (int i = 0; i < this.dependentProperty.length; ++i) {
            String string = this.bean.getValue(this.dependentProperty[i]).toString();
            boolean bl = this.dependentValue[i].equals(string);
            if (!this.isDependencyEquality[i]) {
                boolean bl2 = bl = !bl;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public void setBean(Bean<C> bean) {
        this.bean = bean;
        bean.addPropertyChangeListener(this);
        this.refresh();
    }

    public Bean<C> getBean() {
        return this.bean;
    }

    public PropertyDescriptor getProperty() {
        return this.property;
    }

    public void refresh() {
        this.refresh(this.getValue());
        this.setEnabled(this.isDependencySatisfied());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(this.property.getName())) {
            this.refresh(propertyChangeEvent.getNewValue());
        }
        this.setEnabled(this.isDependencySatisfied());
    }

    protected void applyValue(T t) {
        this.bean.setValue(this.property, t);
    }

    protected T getValue() {
        Object object = this.getBean().getValue(this.getProperty().getName());
        return (T)(object != null ? object : this.getNullValue());
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._setEnabled(bl);
        for (Component component : this.getComponents()) {
            component.setEnabled(bl);
        }
    }

    @Override
    public void setToolTipText(String string) {
        super.setToolTipText(string);
        for (Component component : this.getComponents()) {
            ((JComponent)component).setToolTipText(string);
        }
    }

    @Override
    public void actionPerformed(final ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Configurator.this._actionPerformed(actionEvent);
            }
        });
    }

    protected Adjustable getAdjustable() {
        return this.property.getWriteMethod().getAnnotation(Adjustable.class);
    }

    protected abstract void _actionPerformed(ActionEvent var1);

    protected abstract void _setEnabled(boolean var1);
}

