/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.sdedit.ui.components.ButtonPanel;
import net.sf.sdedit.ui.components.configuration.Adjustable;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.ConfigurationDialog;
import net.sf.sdedit.ui.components.configuration.Configurator;
import net.sf.sdedit.ui.components.configuration.ConfiguratorFactory;
import net.sf.sdedit.ui.components.configuration.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationUI<C extends DataObject>
extends JPanel {
    private Map<String, JPanel> categoryMap;
    private ConfiguratorFactory<C> configuratorFactory;
    private Map<String, List<Configurator<?, C>>> configurators;
    private Map<String, Integer> labelWidths;
    private JList categoryList;
    private JPanel right;
    private ConfigurationDialog parent;
    private Bean<C> bean;
    private Bean<C> formerState;
    private Bean<C> defaultBean;
    private ButtonPanel buttonPanel;
    private JPanel categoryListPanel;
    private Action ok = new AbstractAction(){
        {
            this.putValue("Name", "OK");
            this.putValue("ShortDescription", "Acknowledges all changes made since this dialog has been opened");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ConfigurationUI.this.parent.setVisible(false);
            ConfigurationUI.this.parent.apply();
        }
    };
    private Action cancel = new AbstractAction(){
        {
            this.putValue("Name", "Cancel");
            this.putValue("ShortDescription", "Cancels all changes made since this dialog has been opened");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ConfigurationUI.this.parent.cancel();
            ConfigurationUI.this.parent.setVisible(false);
        }
    };

    public ConfigurationUI(ConfigurationDialog configurationDialog, Bean<C> bean, Bean<C> bean2, String string, String string2, String string3) {
        String string4;
        String string5;
        String[] stringArray;
        Object object;
        this.bean = bean;
        this.formerState = bean.copy();
        this.defaultBean = bean2;
        this.setLayout(new BorderLayout());
        this.parent = configurationDialog;
        this.right = new JPanel();
        this.right.setLayout(new BorderLayout());
        this.right.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.configuratorFactory = new ConfiguratorFactory();
        this.configurators = new HashMap();
        this.categoryListPanel = new JPanel();
        this.categoryListPanel.setLayout(new BorderLayout());
        this.categoryListPanel.add((Component)new JLabel("Categories:"), "North");
        this.categoryList = new JList();
        JScrollPane jScrollPane = new JScrollPane(this.categoryList);
        this.categoryListPanel.add((Component)jScrollPane, "Center");
        this.add((Component)this.categoryListPanel, "West");
        this.add((Component)this.right, "Center");
        if (string3 != null) {
            object = new JLabel(string3);
            ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)object, "North");
        }
        this.labelWidths = new HashMap<String, Integer>();
        this.categoryMap = new TreeMap<String, JPanel>();
        this.categoryList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                String string = (String)ConfigurationUI.this.categoryList.getSelectedValue();
                if (string != null) {
                    JPanel jPanel = (JPanel)ConfigurationUI.this.categoryMap.get(string);
                    ConfigurationUI.this.right.removeAll();
                    ConfigurationUI.this.right.add((Component)jPanel, "Center");
                    ConfigurationUI.this.right.updateUI();
                }
            }
        });
        object = this.categoryList.getCellRenderer();
        this.categoryList.setCellRenderer(new ListCellRenderer((ListCellRenderer)object){
            final /* synthetic */ ListCellRenderer val$lcr;
            {
                this.val$lcr = listCellRenderer;
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JComponent jComponent = (JComponent)this.val$lcr.getListCellRendererComponent(jList, object, n, bl, bl2);
                jComponent.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
                return jComponent;
            }
        });
        this.buttonPanel = new ButtonPanel();
        this.add((Component)this.buttonPanel, "South");
        this.buttonPanel.addAction(this.cancel);
        if (string2 != null) {
            stringArray = string2.split("\\|");
            string5 = stringArray[0];
            string4 = stringArray.length == 1 ? "" : stringArray[1];
            this.buttonPanel.addAction(this.restoreDefaultsAction(string5, string4));
        }
        if (string != null) {
            stringArray = string.split("\\|");
            string5 = stringArray[0];
            string4 = stringArray.length == 1 ? "" : stringArray[1];
            this.buttonPanel.addAction(this.saveAsDefaultAction(string5, string4));
        }
        this.buttonPanel.addAction(this.ok);
        this.init(bean, bean2);
        this.refreshAll();
    }

    public void hideCategoryList() {
        this.remove(this.categoryListPanel);
    }

    public void hideButtons() {
        this.remove(this.buttonPanel);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.categoryList.setEnabled(bl);
        for (Configurator<?, C> configurator : this.getConfigurators()) {
            configurator.setEnabled(bl && configurator.isDependencySatisfied());
        }
    }

    private List<Configurator<?, C>> getConfigurators() {
        LinkedList linkedList = new LinkedList();
        for (List<Configurator<?, C>> list : this.configurators.values()) {
            linkedList.addAll(list);
        }
        return linkedList;
    }

    public Collection<JPanel> getCategoryPanels() {
        return this.categoryMap.values();
    }

    private void init(Bean<C> bean, Bean<C> bean2) {
        for (PropertyDescriptor object : bean.getProperties()) {
            if (!object.getWriteMethod().getAnnotation(Adjustable.class).editable()) continue;
            this.add(bean, object, bean2);
        }
        for (Map.Entry entry : this.configurators.entrySet()) {
            int n = this.labelWidths.get(entry.getKey());
            for (Configurator configurator : (List)entry.getValue()) {
                configurator.setLabelWidth(n);
            }
        }
    }

    private void add(Bean<C> bean, PropertyDescriptor propertyDescriptor, Bean<C> bean2) {
        Method method = propertyDescriptor.getWriteMethod();
        if (method.isAnnotationPresent(Adjustable.class)) {
            Adjustable adjustable = method.getAnnotation(Adjustable.class);
            if (adjustable.editable()) {
                String string = adjustable.category();
                JPanel jPanel = this.categoryMap.get(string);
                int n = 0;
                if (jPanel == null) {
                    jPanel = new JPanel();
                    jPanel.setLayout(new BoxLayout(jPanel, 1));
                    jPanel.setBorder(new TitledBorder(string));
                    this.configurators.put(string, new LinkedList());
                    this.categoryMap.put(string, jPanel);
                    this.categoryList.setListData(this.categoryMap.keySet().toArray());
                    if (this.categoryMap.keySet().iterator().next().equals(string)) {
                        this.right.removeAll();
                        this.right.add((Component)jPanel, "Center");
                    }
                    this.categoryList.setSelectedIndex(0);
                } else {
                    n = this.labelWidths.get(string);
                }
                Configurator<?, C> configurator = this.configuratorFactory.createConfigurator(bean, propertyDescriptor, bean2);
                if (adjustable.tooltip().length() > 0) {
                    configurator.setToolTipText(adjustable.tooltip());
                }
                n = Math.max(n, configurator.getLabelWidth());
                this.labelWidths.put(string, n);
                int n2 = configurator.getPreferredSize().height;
                Dimension dimension = new Dimension(500, n2);
                configurator.setMinimumSize(dimension);
                configurator.setPreferredSize(dimension);
                configurator.setMaximumSize(dimension);
                configurator.setAlignmentX(0.0f);
                this.configurators.get(string).add(configurator);
                jPanel.add(configurator);
                int n3 = 15 * adjustable.gap();
                jPanel.add(Box.createRigidArea(new Dimension(1, n3)));
            }
        } else {
            throw new IllegalArgumentException("No Adjustable annotation present for property " + propertyDescriptor.getName());
        }
    }

    public void setBean(Bean<C> bean) {
        this.bean = bean;
        this.formerState = bean.copy();
        for (Configurator<?, C> configurator : this.getConfigurators()) {
            configurator.setBean(bean);
        }
    }

    public void refreshAll() {
        for (Configurator<?, C> configurator : this.getConfigurators()) {
            configurator.refresh();
        }
    }

    public void apply() {
        this.formerState.takeValuesFrom(this.bean);
    }

    public void cancel() {
        this.bean.takeValuesFrom(this.formerState);
    }

    private Action restoreDefaultsAction(final String string, final String string2) {
        return new AbstractAction(){
            {
                this.putValue("Name", string);
                this.putValue("ShortDescription", string2);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (ConfigurationUI.this.defaultBean != null) {
                    ConfigurationUI.this.bean.takeValuesFrom(ConfigurationUI.this.defaultBean);
                }
            }
        };
    }

    private Action saveAsDefaultAction(final String string, final String string2) {
        return new AbstractAction(){
            {
                this.putValue("Name", string);
                this.putValue("ShortDescription", string2);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (ConfigurationUI.this.defaultBean != null) {
                    ConfigurationUI.this.defaultBean.takeValuesFrom(ConfigurationUI.this.bean);
                }
            }
        };
    }
}

