/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration;

import java.awt.event.ActionEvent;
import java.beans.PropertyDescriptor;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import net.sf.sdedit.icons.Icons;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigurationAction<T extends DataObject>
extends AbstractAction
implements Runnable {
    private String property;
    private AbstractButton button;
    private boolean listen;

    protected abstract Bean<T> getBean();

    public ConfigurationAction(String string, String string2, String string3, String string4) {
        this.putValue("Name", string2);
        this.putValue("ShortDescription", string3);
        this.putValue("SmallIcon", Icons.getIcon(string4));
        this.property = string;
        this.listen = true;
    }

    public void setButton(AbstractButton abstractButton) {
        this.button = abstractButton;
    }

    public void update() {
        if (this.getBean() != null) {
            Boolean bl = (Boolean)this.getBean().getValue(this.property);
            if (this.button != null) {
                this.listen = false;
                this.button.setSelected(bl);
                this.listen = true;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.listen) {
            SwingUtilities.invokeLater(this);
        }
    }

    @Override
    public void run() {
        Boolean bl = this.button.isSelected();
        PropertyDescriptor propertyDescriptor = this.getBean().getProperty(this.property);
        this.getBean().setValue(propertyDescriptor, bl);
    }
}

