/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyDescriptor;
import java.io.File;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.DataObject;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanConverter {
    private Bean<? extends DataObject> bean;
    private Document document;

    public BeanConverter(Bean<? extends DataObject> bean, Document document) {
        this.document = document;
        this.bean = bean;
    }

    public Element createElement(String string) {
        Element element = this.document.createElement(string);
        for (PropertyDescriptor propertyDescriptor : this.bean.getProperties()) {
            element.appendChild(this.convertProperty(propertyDescriptor));
        }
        return element;
    }

    public void setValues(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            this.setElementValue((Element)nodeList.item(i));
        }
    }

    private Element convertProperty(PropertyDescriptor propertyDescriptor) {
        Element element = this.document.createElement("property");
        element.setAttribute("name", propertyDescriptor.getName());
        Object object = this.bean.getValue(propertyDescriptor.getName());
        if (object instanceof String) {
            CDATASection cDATASection = this.document.createCDATASection((String)object);
            element.appendChild(cDATASection);
        } else if (object instanceof Integer) {
            element.setAttribute("value", object.toString());
        } else if (object instanceof Boolean) {
            element.setAttribute("value", object.toString());
        } else if (object instanceof Font) {
            Font font = (Font)object;
            element.setAttribute("family", font.getFamily());
            element.setAttribute("style", String.valueOf(font.getStyle()));
            element.setAttribute("size", String.valueOf(font.getSize()));
        } else if (object instanceof File) {
            element.setAttribute("value", ((File)object).getAbsolutePath());
        } else if (object instanceof Color) {
            element.setAttribute("value", "" + ((Color)object).getRGB());
        } else {
            throw new IllegalArgumentException("unknown property type: " + object.getClass().getName());
        }
        return element;
    }

    private void setElementValue(Element element) {
        String string = element.getAttribute("name");
        PropertyDescriptor propertyDescriptor = this.bean.getProperty(string);
        if (propertyDescriptor == null) {
            System.err.println("Warning: " + string + " is not a property");
        } else {
            Object object = null;
            Class<?> clazz = propertyDescriptor.getPropertyType();
            if (clazz.equals(String.class)) {
                object = element.getTextContent();
            } else if (clazz.equals(Integer.TYPE)) {
                object = BeanConverter.parseInt(element.getAttribute("value"));
            } else if (clazz.equals(Boolean.TYPE)) {
                object = BeanConverter.parseBool(element.getAttribute("value"));
            } else if (clazz.equals(Font.class)) {
                String string2 = element.getAttribute("family");
                int n = BeanConverter.parseInt(element.getAttribute("style"));
                int n2 = BeanConverter.parseInt(element.getAttribute("size"));
                if (n2 == 0) {
                    n2 = 12;
                }
                object = new Font(string2, n, n2);
            } else if (clazz.equals(File.class)) {
                String string3 = element.getAttribute("value");
                object = new File(string3);
            } else if (clazz.equals(Color.class)) {
                String string4 = element.getAttribute("value");
                object = new Color(Integer.parseInt(string4));
            }
            if (object == null) {
                System.err.println("Warning: a value for property " + string + " could not be created");
            } else {
                this.bean.setValue(propertyDescriptor, object);
            }
        }
    }

    private static int parseInt(String string) {
        int n = 0;
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    private static boolean parseBool(String string) {
        boolean bl = false;
        try {
            bl = Boolean.valueOf(string);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return bl;
    }
}

