/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.sdedit.ui.components.configuration.Adjustable;
import net.sf.sdedit.ui.components.configuration.BeanConverter;
import net.sf.sdedit.ui.components.configuration.DataObject;
import net.sf.sdedit.ui.components.configuration.NullValueProvider;
import net.sf.sdedit.ui.components.configuration.StringSelectionProvider;
import net.sf.sdedit.util.DocUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bean<T extends DataObject>
implements InvocationHandler {
    private Set<PropertyChangeListener> listeners;
    private SortedMap<String, PropertyDescriptor> properties;
    private SortedMap<String, String> order;
    private HashMap<String, Object> values;
    private Class<T> dataClass;
    private T dataObject;
    private StringSelectionProvider<T> ssp;
    private boolean permitNullValues;
    private Map<String, Set<String>> stringSets;
    private Map<String, String> methodToPropertyNameMap;
    private Pattern pattern = Pattern.compile("get|set|is");

    public Bean(Class<T> clazz, StringSelectionProvider stringSelectionProvider) {
        this.listeners = new LinkedHashSet<PropertyChangeListener>();
        this.properties = new TreeMap<String, PropertyDescriptor>();
        this.order = new TreeMap<String, String>();
        this.values = new HashMap();
        this.ssp = stringSelectionProvider;
        this.dataClass = clazz;
        this.stringSets = new HashMap<String, Set<String>>();
        this.init();
        this.dataObject = (DataObject)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
        this.permitNullValues = false;
        this.methodToPropertyNameMap = new HashMap<String, String>();
    }

    private static String norm(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    private void init() {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.dataClass);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                if (propertyDescriptor.getWriteMethod() == null || !propertyDescriptor.getWriteMethod().isAnnotationPresent(Adjustable.class)) continue;
                String string = propertyDescriptor.getWriteMethod().getAnnotation(Adjustable.class).key();
                if (string.equals("")) {
                    string = Bean.norm(propertyDescriptor.getName());
                }
                this.order.put(string, Bean.norm(propertyDescriptor.getName()));
                this.properties.put(Bean.norm(propertyDescriptor.getName()), propertyDescriptor);
                if (this.getValue(propertyDescriptor) != null) continue;
                this.setValue(propertyDescriptor, NullValueProvider.getNullValue(propertyDescriptor.getPropertyType()));
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new IllegalStateException("FATAL: data class introspection was not successful");
        }
    }

    public T getDataObject() {
        return this.dataObject;
    }

    @Override
    public final Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        String string = method.getName();
        if ("toString".equals(string) && method.getParameterTypes().length == 0) {
            return this.values.toString();
        }
        String string2 = this.methodToPropertyNameMap.get(string);
        if (string2 == null) {
            Matcher matcher = this.pattern.matcher(string);
            string2 = matcher.replaceFirst("");
            this.methodToPropertyNameMap.put(string, string2);
        }
        if (string.charAt(0) == 's') {
            this.setValue((PropertyDescriptor)this.properties.get(string2), objectArray[0]);
            return null;
        }
        return this.getValue(string2);
    }

    public Collection<PropertyDescriptor> getProperties() {
        LinkedList<PropertyDescriptor> linkedList = new LinkedList<PropertyDescriptor>();
        for (String string : this.order.values()) {
            linkedList.add((PropertyDescriptor)this.properties.get(string));
        }
        return linkedList;
    }

    public PropertyDescriptor getProperty(String string) {
        return (PropertyDescriptor)this.properties.get(Bean.norm(string));
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.remove(propertyChangeListener);
    }

    public void takeValuesFrom(Bean<T> bean) {
        for (PropertyDescriptor propertyDescriptor : this.getProperties()) {
            this.setValue(propertyDescriptor, bean.getValue(propertyDescriptor.getName()));
        }
    }

    public Bean<T> copy() {
        Bean<T> bean = new Bean<T>(this.dataClass, this.ssp);
        bean.takeValuesFrom(this);
        return bean;
    }

    public final Object getValue(String string) {
        return this.values.get(Bean.norm(string));
    }

    public final Object getValue(PropertyDescriptor propertyDescriptor) {
        return this.getValue(propertyDescriptor.getName());
    }

    public void load(Document document, String string) throws DocUtil.XMLException {
        Element element = (Element)DocUtil.evalXPathAsNode(document, string);
        if (element != null) {
            BeanConverter beanConverter = new BeanConverter(this, document);
            beanConverter.setValues(element);
        }
    }

    public void store(Document document, String string, String string2) throws DocUtil.XMLException {
        Element element = (Element)DocUtil.evalXPathAsNode(document, string);
        BeanConverter beanConverter = new BeanConverter(this, document);
        Element element2 = beanConverter.createElement(string2);
        element.appendChild(element2);
    }

    public final void setValue(PropertyDescriptor propertyDescriptor, Object object) {
        Object object2;
        if (object == null && !this.permitNullValues) {
            return;
        }
        if (propertyDescriptor.getPropertyType() == String.class && !(object2 = this.getStringsForProperty(propertyDescriptor)).isEmpty() && !object2.contains(object)) {
            return;
        }
        object2 = Bean.norm(propertyDescriptor.getName());
        Object object3 = this.values.get(object2);
        this.values.put((String)object2, object);
        this.firePropertyChanged(propertyDescriptor, object, object3);
    }

    private void firePropertyChanged(PropertyDescriptor propertyDescriptor, Object object, Object object2) {
        if (object == null && object2 == null) {
            return;
        }
        if (object == null || object2 == null || !object.equals(object2)) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, propertyDescriptor.getName(), object2, object);
            for (PropertyChangeListener propertyChangeListener : this.listeners) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    public boolean equals(Object object) {
        Bean bean = (Bean)object;
        for (PropertyDescriptor propertyDescriptor : this.getProperties()) {
            Object object2 = this.getValue(propertyDescriptor.getName());
            Object object3 = bean.getValue(propertyDescriptor.getName());
            if (object2 == null && object3 == null) continue;
            if (object2 == null || object3 == null) {
                return false;
            }
            if (object2.equals(object3)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        StringBuffer stringBuffer = new StringBuffer();
        for (PropertyDescriptor propertyDescriptor : this.getProperties()) {
            Object object = this.getValue(propertyDescriptor.getName());
            stringBuffer.append(object);
        }
        return stringBuffer.hashCode();
    }

    public Set<String> getStringsForProperty(PropertyDescriptor propertyDescriptor) {
        String string = Bean.norm(propertyDescriptor.getName());
        Set<String> set = this.stringSets.get(string);
        if (set == null) {
            set = new LinkedHashSet<String>();
            Adjustable adjustable = propertyDescriptor.getWriteMethod().getAnnotation(Adjustable.class);
            String[] stringArray = adjustable.choices();
            if (stringArray.length == 0 && adjustable.stringSelectionProvided()) {
                stringArray = this.ssp.getStringSelection(propertyDescriptor.getName());
            }
            for (String string2 : stringArray) {
                set.add(string2);
            }
            this.stringSets.put(Bean.norm(propertyDescriptor.getName()), set);
        }
        return set;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (PropertyDescriptor propertyDescriptor : this.getProperties()) {
            stringBuffer.append(propertyDescriptor.getName() + "=");
            stringBuffer.append(this.getValue(propertyDescriptor.getName()));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public boolean isPermitNullValues() {
        return this.permitNullValues;
    }

    public void setPermitNullValues(boolean bl) {
        this.permitNullValues = bl;
    }
}

