/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.buttons;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.Timer;
import net.sf.sdedit.ui.components.buttons.Activator;
import net.sf.sdedit.ui.components.configuration.ConfigurationAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnableComponents
implements ActionListener {
    private Map<JComponent, Activator> activatorMap = new HashMap<JComponent, Activator>();
    private List<ConfigurationAction<?>> configurationActions = new LinkedList();
    private Timer timer = new Timer(250, this);
    private boolean timeToEnable = false;

    public EnableComponents() {
        this.timer.start();
    }

    private void _activateComponents() {
        for (Map.Entry<JComponent, Activator> object : this.activatorMap.entrySet()) {
            object.getKey().setEnabled(object.getValue().isEnabled());
        }
        for (ConfigurationAction configurationAction : this.configurationActions) {
            configurationAction.update();
        }
    }

    public synchronized void enableComponents() {
        this.timeToEnable = true;
        this.timer.restart();
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (this.timeToEnable) {
            this._activateComponents();
            this.timeToEnable = false;
        }
    }

    public void registerButton(JComponent jComponent, Activator activator) {
        this.activatorMap.put(jComponent, activator);
    }

    public void registerConfigurationAction(ConfigurationAction<?> configurationAction, AbstractButton abstractButton) {
        configurationAction.setButton(abstractButton);
        this.configurationActions.add(configurationAction);
    }
}

