/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import net.sf.sdedit.ui.components.GrabbableViewport;
import net.sf.sdedit.ui.components.Scalable;
import net.sf.sdedit.ui.components.Zoomable;

public class ZoomPane
extends JPanel
implements Scalable,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -1422640857L;
    private double scale = 1.0;
    private Zoomable<? extends JComponent> viewPort;
    private JScrollPane scrollPane;
    private List<MouseListener> mouseListeners;
    private List<MouseMotionListener> mouseMotionListeners;
    private MyObservable observable = new MyObservable();
    private JComponent root;
    private JPanel internal = new JPanel(){

        public Dimension getPreferredSize() {
            if (ZoomPane.this.viewPort == null) {
                return super.getPreferredSize();
            }
            return new Dimension((int)((double)ZoomPane.this.viewPort.getAbsoluteWidth() * ZoomPane.this.scale), (int)((double)ZoomPane.this.viewPort.getAbsoluteHeight() * ZoomPane.this.scale));
        }

        public void setCursor(Cursor cursor) {
            ZoomPane.this.root.setCursor(cursor);
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            if (ZoomPane.this.viewPort == null) {
                return "";
            }
            return ((JComponent)ZoomPane.this.viewPort.asJComponent()).getToolTipText(ZoomPane.this.translate(mouseEvent));
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.scale(ZoomPane.this.scale, ZoomPane.this.scale);
            if (ZoomPane.this.viewPort == null) {
                Rectangle rectangle = graphics2D.getClipBounds();
                graphics2D.setColor(Color.WHITE);
                graphics2D.fill(rectangle);
            } else {
                ZoomPane.this.viewPort.paintComponent(graphics2D);
            }
            graphics2D.dispose();
        }
    };

    public ZoomPane() {
        this(true);
    }

    public ZoomPane(boolean bl) {
        this.mouseListeners = new LinkedList<MouseListener>();
        this.mouseMotionListeners = new LinkedList<MouseMotionListener>();
        this.inheritListeners();
        this.setLayout(new BorderLayout());
        this.internal.addMouseListener(this);
        this.internal.addMouseMotionListener(this);
        GrabbableViewport grabbableViewport = new GrabbableViewport();
        ((JViewport)grabbableViewport).setView(this.internal);
        if (bl) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewport(grabbableViewport);
            this.scrollPane.setDoubleBuffered(true);
            this.scrollPane.getVerticalScrollBar().setUnitIncrement(30);
            this.add((Component)this.scrollPane, "Center");
        } else {
            this.add((Component)this.internal, "Center");
        }
        this.root = this;
    }

    public void setRoot(JComponent jComponent) {
        this.root = jComponent;
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.internal.addMouseListener(mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.internal.addMouseMotionListener(mouseMotionListener);
    }

    public JPanel getPanel() {
        return this.internal;
    }

    public void scrollToBottom() {
        this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getMaximum());
    }

    public void scrollToPosition(float f, float f2) {
        int n = this.internal.getVisibleRect().width / 2;
        int n2 = this.internal.getVisibleRect().height / 2;
        int n3 = this.scrollPane.getVerticalScrollBar().getMaximum();
        int n4 = (int)(f2 * (float)n3);
        this.scrollPane.getVerticalScrollBar().setValue(n4 - n2);
        int n5 = this.scrollPane.getHorizontalScrollBar().getMaximum();
        int n6 = (int)(f * (float)n5);
        this.scrollPane.getHorizontalScrollBar().setValue(n6 - n);
    }

    public void home() {
        this.scrollPane.getHorizontalScrollBar().setValue(0);
        this.scrollPane.getVerticalScrollBar().setValue(0);
    }

    private void inheritListeners() {
        this.mouseListeners.clear();
        this.mouseMotionListeners.clear();
        if (this.viewPort != null) {
            this.mouseListeners.addAll(Arrays.asList(((Component)((Object)this.viewPort)).getMouseListeners()));
            this.mouseMotionListeners.addAll(Arrays.asList(((Component)((Object)this.viewPort)).getMouseMotionListeners()));
        }
    }

    public void fitWidth() {
        if (this.viewPort == null) {
            return;
        }
        this.setScale(1.0 * (double)this.getWidth() / (double)this.viewPort.getAbsoluteWidth());
    }

    public void fitHeight() {
        if (this.viewPort == null) {
            return;
        }
        this.setScale(1.0 * (double)this.getHeight() / (double)this.viewPort.getAbsoluteHeight());
    }

    public void fitSize() {
        if (this.viewPort == null) {
            return;
        }
        double d = 1.0 * (double)this.getWidth() / (double)this.viewPort.getAbsoluteWidth();
        double d2 = 1.0 * (double)this.getHeight() / (double)this.viewPort.getAbsoluteHeight();
        this.setScale(Math.min(d, d2));
    }

    public void setScale(double d) {
        Rectangle rectangle = this.internal.getVisibleRect();
        double d2 = d / this.scale;
        this.scale = Math.min(4.0, d);
        this.redraw();
        rectangle = new Rectangle((int)((double)rectangle.x * d2), (int)((double)rectangle.y * d2), (int)((double)rectangle.width * d2), (int)((double)rectangle.height * d2));
        this.internal.scrollRectToVisible(rectangle);
        this.observable.setChanged();
        this.observable.notifyObservers(this);
    }

    public void redraw() {
        if (this.scrollPane != null) {
            this.scrollPane.setViewportView(this.internal);
        }
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void setViewportView(Zoomable zoomable) {
        this.viewPort = zoomable;
        if (zoomable != null) {
            zoomable.setZoomPane(this);
        }
        this.inheritListeners();
        this.redraw();
    }

    public double getScale() {
        return this.scale;
    }

    private MouseEvent translate(MouseEvent mouseEvent) {
        int n = (int)((double)mouseEvent.getX() / this.scale);
        int n2 = (int)((double)mouseEvent.getY() / this.scale);
        return new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), n, n2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseListener.mouseEntered(this.translate(mouseEvent));
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseListener.mouseExited(this.translate(mouseEvent));
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseListener.mouseClicked(this.translate(mouseEvent));
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseListener.mousePressed(this.translate(mouseEvent));
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseListener.mouseReleased(this.translate(mouseEvent));
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        for (MouseMotionListener mouseMotionListener : this.mouseMotionListeners) {
            mouseMotionListener.mouseDragged(this.translate(mouseEvent));
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        for (MouseMotionListener mouseMotionListener : this.mouseMotionListeners) {
            mouseMotionListener.mouseMoved(this.translate(mouseEvent));
        }
    }

    public Observable asObservable() {
        return this.observable;
    }

    private static class MyObservable
    extends Observable {
        private MyObservable() {
        }

        public synchronized void setChanged() {
            super.setChanged();
        }
    }
}

