/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class TextArea
extends JTextPane
implements UndoableEditListener,
Highlighter.HighlightPainter {
    private static final long serialVersionUID = -1422640864L;
    private Highlighter highlighter;
    private UndoManager undoManager = new UndoManager();
    private Object highlight;
    private static final Color ERROR_COLOR = Color.RED;
    private String EOL;

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this.undoManager.addEdit(undoableEditEvent.getEdit());
    }

    public TextArea() {
        this.highlighter = new DefaultHighlighter();
        this.setHighlighter(this.highlighter);
        this.getActionMap().put("Undo", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextArea.this.undo();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        this.getActionMap().put("Redo", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextArea.this.redo();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
        this.EOL = (String)this.getDocument().getProperty("__EndOfLine__");
        this.getDocument().putProperty("__EndOfLine__", "\n");
        this.getDocument().addUndoableEditListener(this);
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        super.paintComponent(graphics);
    }

    public void undo() {
        try {
            if (this.undoManager.canUndo()) {
                this.undoManager.undo();
                for (KeyListener keyListener : this.getKeyListeners()) {
                    keyListener.keyTyped(null);
                    keyListener.keyReleased(null);
                }
            }
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
    }

    public void redo() {
        try {
            if (this.undoManager.canRedo()) {
                this.undoManager.redo();
                for (KeyListener keyListener : this.getKeyListeners()) {
                    keyListener.keyTyped(null);
                    keyListener.keyReleased(null);
                }
            }
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
    }

    public void markError(int n, int n2) {
        if (this.highlight != null) {
            this.highlighter.removeHighlight(this.highlight);
        }
        if (n >= 0) {
            try {
                this.highlight = this.highlighter.addHighlight(n, n2, this);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    public int getCaretLine() {
        int n = this.getCaretPosition();
        String string = this.getText();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '\n') continue;
            ++n2;
        }
        return n2;
    }

    private String getText(boolean bl) {
        String string;
        if (bl) {
            this.getDocument().putProperty("__EndOfLine__", this.EOL);
            string = super.getText();
            this.getDocument().putProperty("__EndOfLine__", "\n");
        } else {
            string = super.getText();
        }
        return string;
    }

    public String getText() {
        return this.getText(false);
    }

    public int getCurrentLineBegin() {
        char c;
        int n;
        int n2 = this.getCaretPosition();
        String string = this.getText();
        for (n = Math.min(string.length() - 1, n2); n >= 0 && ((c = string.charAt(n)) == '\n' || c == '\r'); --n) {
        }
        while (n >= 0) {
            c = string.charAt(n);
            if (c == '\n' || c == '\r') {
                return n + 2;
            }
            --n;
        }
        return 0;
    }

    private void paintLine(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = rectangle.y + rectangle.height - 3;
        for (int i = rectangle.x; i < n - rectangle.x; i += 2) {
            graphics.drawLine(i, n2, i + 1, n2 + 1);
            graphics.drawLine(i + 1, n2 + 1, i + 2, n2);
        }
    }

    public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
        Rectangle rectangle = null;
        Rectangle rectangle2 = null;
        Rectangle rectangle3 = shape.getBounds();
        int n3 = rectangle3.x + rectangle3.width;
        try {
            rectangle = jTextComponent.modelToView(n);
            rectangle2 = jTextComponent.modelToView(n2);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        if (rectangle == null || rectangle2 == null) {
            return;
        }
        graphics.setColor(ERROR_COLOR);
        if (rectangle.y == rectangle2.y) {
            this.paintLine(graphics, rectangle, rectangle2.x);
            return;
        }
        this.paintLine(graphics, rectangle, n3);
        rectangle.y += rectangle.height;
        rectangle.x = rectangle3.x;
        while (rectangle.y < rectangle2.y) {
            this.paintLine(graphics, rectangle, n3);
            rectangle.y += rectangle.height;
        }
        this.paintLine(graphics, rectangle, rectangle2.x);
    }
}

