/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;
import net.sf.sdedit.icons.Icons;
import net.sf.sdedit.ui.components.Scalable;

public class ScalePanel
extends JPanel
implements Observer,
MouseInputListener {
    private static final long serialVersionUID = -1422640859L;
    private static ImageIcon fitHeightIcon = Icons.getIcon("large/fit_height");
    private static ImageIcon fitWidthIcon = Icons.getIcon("large/fit_width");
    private static ImageIcon fitWindowIcon = Icons.getIcon("large/fit_window");
    private static ImageIcon normalSizeIcon = Icons.getIcon("large/normalsize");
    private JSlider scaleSlider;
    private JLabel sliderLabel;
    private Scalable scalable;
    private Point root = null;
    private int initialValue;
    public final Action fitWidthAction = new AbstractAction(){
        {
            this.putValue("ShortDescription", "Fit width");
            this.putValue("SmallIcon", fitWidthIcon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ScalePanel.this.fitWidth();
        }
    };
    public final Action fitHeightAction = new AbstractAction(){
        {
            this.putValue("ShortDescription", "Fit height");
            this.putValue("SmallIcon", fitHeightIcon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ScalePanel.this.fitHeight();
        }
    };
    public final Action fitWindowAction = new AbstractAction(){
        {
            this.putValue("ShortDescription", "Fit window");
            this.putValue("SmallIcon", fitWindowIcon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ScalePanel.this.fitWindow();
        }
    };
    public final Action normalSizeAction = new AbstractAction(){
        {
            this.putValue("ShortDescription", "Zoom to 100 %");
            this.putValue("SmallIcon", normalSizeIcon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ScalePanel.this.normalsize();
        }
    };

    public ScalePanel(boolean bl) {
        this.setLayout(new BorderLayout());
        this.sliderLabel = new JLabel();
        this.sliderLabel.setToolTipText("Zoom factor");
        this.sliderLabel.setPreferredSize(new Dimension(40, 1));
        this.sliderLabel.setOpaque(false);
        this.add((Component)this.sliderLabel, "West");
        this.scaleSlider = new JSlider(1, 400, 100);
        this.scaleSlider.setPreferredSize(new Dimension(100, 0));
        this.scaleSlider.setMaximumSize(new Dimension(100, 0));
        this.scaleSlider.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (ScalePanel.this.isEnabled() && mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                    ScalePanel.this.scalable.setScale(1.0);
                }
            }
        });
        this.scaleSlider.setOpaque(false);
        this.scaleSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = (double)(ScalePanel.this.scaleSlider.getValue() * ScalePanel.this.scaleSlider.getValue()) / 40000.0;
                d = Math.max(0.01, d);
                ScalePanel.this.scalable.setScale(d);
            }
        });
        this.add((Component)this.scaleSlider, "Center");
        if (bl) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(1, 4));
            JButton jButton = new JButton(this.normalSizeAction);
            JButton jButton2 = new JButton(this.fitHeightAction);
            JButton jButton3 = new JButton(this.fitWidthAction);
            JButton jButton4 = new JButton(this.fitWindowAction);
            jButton.setMargin(new Insets(1, 1, 1, 1));
            jButton.setOpaque(false);
            jButton2.setMargin(new Insets(1, 1, 1, 1));
            jButton2.setOpaque(false);
            jButton3.setMargin(new Insets(1, 1, 1, 1));
            jButton3.setOpaque(false);
            jButton4.setMargin(new Insets(1, 1, 1, 1));
            jButton4.setOpaque(false);
            jPanel.add(jButton);
            jPanel.add(jButton2);
            jPanel.add(jButton3);
            jPanel.add(jButton4);
            jPanel.setOpaque(false);
            this.add((Component)jPanel, "East");
        }
    }

    private void normalsize() {
        if (this.scalable != null) {
            this.scalable.setScale(1.0);
        }
    }

    private void fitWidth() {
        if (this.scalable != null) {
            this.scalable.fitWidth();
        }
    }

    private void fitHeight() {
        if (this.scalable != null) {
            this.scalable.fitHeight();
        }
    }

    private void fitWindow() {
        if (this.scalable != null) {
            this.scalable.fitSize();
        }
    }

    public void setScalable(Scalable scalable) {
        scalable.asObservable().deleteObservers();
        scalable.asObservable().addObserver(this);
        this.scalable = scalable;
        this.update(scalable.asObservable(), scalable);
    }

    public JSlider getSlider() {
        return this.scaleSlider;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.root = mouseEvent.getPoint();
            this.initialValue = this.scaleSlider.getValue();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.root = null;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.scaleSlider.setEnabled(bl);
        this.sliderLabel.setEnabled(bl);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        if (this.root != null && Math.abs(n = (this.root.y - mouseEvent.getPoint().y) / 4) > 0) {
            int n2 = this.initialValue + n;
            n2 = Math.max(n2, this.scaleSlider.getMinimum());
            n2 = Math.min(n2, this.scaleSlider.getMaximum());
            this.scaleSlider.setValue(n2);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public synchronized void update(Observable observable, Object object) {
        Scalable scalable = (Scalable)object;
        double d = scalable.getScale();
        int n = (int)(200.0 * Math.sqrt(d));
        String string = (int)(d * 100.0) + " %";
        this.sliderLabel.setText(string);
        this.scaleSlider.setValue(n);
    }
}

