/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuBar
extends JMenuBar {
    private static final long serialVersionUID = 516995753L;
    private Map<String, JMenu> categories = new HashMap<String, JMenu>();
    private Map<String, Action> nameMap = new HashMap<String, Action>();

    public Action getActionByName(String string) {
        return this.nameMap.get(string);
    }

    public static <T extends JMenuItem> T makeMenuItem(String string, Class<T> clazz) {
        return MenuBar.makeMenuItem(string, string, String.class, clazz);
    }

    private static <T extends JMenuItem> T makeMenuItem(String string, Object object, Class<?> clazz, Class<T> clazz2) {
        try {
            KeyStroke keyStroke = null;
            if (string.charAt(0) == '[') {
                int n = string.indexOf(93);
                String string2 = string.substring(1, n);
                keyStroke = KeyStroke.getKeyStroke(string2);
            }
            Constructor<T> constructor = clazz2.getConstructor(clazz);
            int n = string.indexOf(38);
            JMenuItem jMenuItem = (JMenuItem)constructor.newInstance(object);
            jMenuItem.setText(MenuBar.getCaption(string));
            if (n < string.length() - 1) {
                jMenuItem.setMnemonic(string.charAt(n + 1));
            }
            if (keyStroke != null) {
                jMenuItem.setAccelerator(keyStroke);
            }
            return (T)jMenuItem;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InternalError();
        }
    }

    private static String getCaption(String string) {
        String string2 = string;
        if (string.charAt(0) == '[') {
            int n = string.indexOf(93);
            string2 = string.substring(n + 1);
        }
        String string3 = "";
        int n = string2.indexOf(38);
        if (n > 0) {
            string3 = string2.substring(0, n);
        }
        if (n < string2.length() - 1) {
            string3 = string3 + string2.substring(n + 1);
        }
        return string3;
    }

    public void removeAction(String string, Action action) {
        JMenu jMenu = this.categories.get(MenuBar.getCaption(string));
        if (jMenu == null) {
            return;
        }
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem.getAction() != action) continue;
            jMenu.remove(i);
            return;
        }
    }

    public JMenuItem addAction(String string, Action action, int n) {
        JMenu jMenu = this.categories.get(MenuBar.getCaption(string));
        if (jMenu == null) {
            int n2 = string.lastIndexOf(46);
            if (n2 == -1) {
                jMenu = MenuBar.makeMenuItem(string, JMenu.class);
                this.add(jMenu);
                this.categories.put(MenuBar.getCaption(string), jMenu);
            } else {
                String string2 = string.substring(n2 + 1);
                String string3 = string.substring(0, n2);
                JMenu jMenu2 = this.categories.get(MenuBar.getCaption(string3));
                if (jMenu2 == null) {
                    throw new IllegalArgumentException("menu for category " + string3 + " must" + " exist before a subcategory " + string2 + " can be added");
                }
                jMenu = MenuBar.makeMenuItem(string2, JMenu.class);
                jMenu2.add(jMenu);
                this.categories.put(MenuBar.getCaption(string), jMenu);
            }
        }
        JMenuItem jMenuItem = null;
        if (action != null) {
            this.nameMap.put((String)action.getValue("Name"), action);
            jMenuItem = MenuBar.makeMenuItem((String)action.getValue("Name"), action, Action.class, JMenuItem.class);
            if (n == -1) {
                jMenu.add(jMenuItem);
            } else {
                jMenu.insert(jMenuItem, n);
            }
        }
        return jMenuItem;
    }

    public void addMenu(String string, ImageIcon imageIcon) {
        JMenu jMenu;
        int n = string.lastIndexOf(46);
        if (n == -1) {
            jMenu = MenuBar.makeMenuItem(string, JMenu.class);
            if (imageIcon != null) {
                jMenu.setIcon(imageIcon);
            }
            this.add(jMenu);
            this.categories.put(MenuBar.getCaption(string), jMenu);
        } else {
            String string2 = string.substring(n + 1);
            String string3 = string.substring(0, n);
            JMenu jMenu2 = this.categories.get(MenuBar.getCaption(string3));
            if (jMenu2 == null) {
                throw new IllegalArgumentException("menu for category " + string3 + " must" + " exist before a subcategory " + string2 + " can be added");
            }
            jMenu = MenuBar.makeMenuItem(string2, JMenu.class);
            jMenu2.add(jMenu);
            this.categories.put(MenuBar.getCaption(string), jMenu);
        }
        if (imageIcon != null) {
            jMenu.setIcon(imageIcon);
        }
    }

    public JMenuItem addAction(String string, Action action) {
        return this.addAction(string, action, -1);
    }

    public void addItem(String string, JMenuItem jMenuItem) {
        JMenu jMenu = this.categories.get(MenuBar.getCaption(string));
        jMenu.add(jMenuItem);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.categories != null) {
            for (JMenu jMenu : this.categories.values()) {
                jMenu.updateUI();
                for (int i = 0; i < jMenu.getItemCount(); ++i) {
                    jMenu.getItem(i).updateUI();
                }
            }
        }
    }
}

