/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.event.MouseInputListener;

public class GrabbableViewport
extends JViewport
implements MouseInputListener {
    private static Cursor HAND = new Cursor(13);
    private static Cursor DFLT = new Cursor(0);
    private Rectangle rect;
    private Point point;
    private JComponent view;

    public static void setHandCursorIcon(ImageIcon imageIcon) {
        Image image = imageIcon.getImage();
        HAND = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "hand cursor");
    }

    public void setView(Component component) {
        super.setView(component);
        if (this.view != component) {
            if (this.view != null) {
                this.view.removeMouseListener(this);
                this.view.removeMouseMotionListener(this);
            }
            if (component != null) {
                component.addMouseListener(this);
                component.addMouseMotionListener(this);
            }
            this.view = (JComponent)component;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.view.setCursor(HAND);
        this.rect = this.getViewRect();
        this.point = this.screenLocation(mouseEvent);
    }

    private Point screenLocation(MouseEvent mouseEvent) {
        Point point = this.view.getLocationOnScreen();
        Point point2 = mouseEvent.getPoint();
        if (this.rect != null && !this.rect.contains(point2)) {
            return null;
        }
        Point point3 = new Point(point.x + point2.x, point.y + point2.y);
        return point3;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.view.setCursor(DFLT);
        this.scrollTo(this.screenLocation(mouseEvent));
        this.clear();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.scrollTo(this.screenLocation(mouseEvent));
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private void scrollTo(Point point) {
        if (this.point != null && point != null && this.rect != null) {
            int n = this.point.x - point.x;
            int n2 = this.point.y - point.y;
            this.rect.x += n;
            this.rect.y += n2;
            ((JComponent)this.getView()).scrollRectToVisible(this.rect);
            this.point = point;
        }
    }

    private void clear() {
        this.rect = null;
        this.point = null;
    }
}

