/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.sf.sdedit.ui.components.FullScreenListener;
import net.sf.sdedit.ui.components.ScalePanel;
import net.sf.sdedit.ui.components.ZoomPane;
import net.sf.sdedit.ui.components.Zoomable;
import net.sf.sdedit.util.base64.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullScreen
extends JFrame
implements KeyListener,
ActionListener {
    private static final long serialVersionUID = -1422640862L;
    private ZoomPane zoomPane;
    private GraphicsDevice gd;
    private ScalePanel scalePanel;
    private List<FullScreenListener> listeners;
    private boolean locked;
    private JPanel closePanel;
    private Timer hideClosePanelTimer;
    private static final String imageString = "iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABGdBTUEAAK/INwWK6QAAAAZiS0dEAP8A/wD/oL2nkwAAAAlwSFlzAAAASAAAAEgARslrPgAAAvdJREFUOMutlF1rXGUQx39zztk9+5LtptuURi+ChhpBikWkXogIghd65Y39AOoXEPEDCEIvJAUv9UoQgqhfwFRBsMWbvnihFKokGiSoqa2N2e55e2bGi7O72cQIIg4Mz8wDz4//DDOPnF3dbGM60CKLrApoGdAqMBtrVaGlYpP7ca5VQIuAViGYhdvSeyQk873W2wu95rPi81LmRlko9Wns50qRO2WulIVhuWIYKoZFinM3+Oin9/3yi2vJQj99/cxSP9YqIsucUQZZBqPRrDujBBAIDh6gFAgxEAPlNrBTEsl60mvG8SCNKYDUhLZDLpAJ5DHkDciakKWQtSDrwChz8h6YAQjabfNLTlqYd5PlY3D+UbCywCTBJcaU2h3c6oe1O2qgCsHAyxJz4Y/dhDffibl5A5JOAx5oZujVj5DBEswtIg8+jLS6HGWO4Dvb2PAevnMV7y/w20NP02kJAJGbQxRjlVN8cIFi9Q1878+/YdwdVSc4lD/cpHzrNapLH1N5ShUcc6+BuEHcJDq5gv/8O7a5XXf/AAzcHTPHDTwI9v0GPorQ48uoAWNg4jYmL62QXlhDogYyf2IfNwOrgQF77An8vXVMwNo97L5OeCQ+jmRwinhw6mChXqubwtwxNbw9h58+U9+roru7+FThBH24a1OYTYFmhs2onfUJJsL838PGsTpYFKMSYw6qNquwhuitG+jXX4CnxOdfwTtzRyoxBLY2iNY/RY61qZ55CWNuKiaaluyBsP4h1dq72HBvOshHAX17k8YnqyTffYmJMNu1WmExRL/9jOjcU+B9XP65XHNDuh2ql1+lEX6ltXUFFp+fAZpB2iF58gV4bhFvH8fiJuKG1Hsxnso6RgN2+ixh+XHCnQ0sbkLYn9vk9r2Cbzb2CLqC7iiqGRqGaDBUFVObxqpWj42D47j3cXf27t9hVBggJJeu/Xjx86+u97SsIq0UDTr+YBWdeKhPqxSrv5jD+x1lw7tbIKUACdA9tG//1Yr/gXHQ/gJla4L5jBzrYgAAACJ6VFh0U29mdHdhcmUAAHjac0zJT0pV8MxNTE8NSk1MqQQAL5wF1K4MqU0AAAAASUVORK5CYII=";
    private static final ImageIcon noFullScreenIcon = new ImageIcon(Base64.decodeBase64EncodedImage("iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABGdBTUEAAK/INwWK6QAAAAZiS0dEAP8A/wD/oL2nkwAAAAlwSFlzAAAASAAAAEgARslrPgAAAvdJREFUOMutlF1rXGUQx39zztk9+5LtptuURi+ChhpBikWkXogIghd65Y39AOoXEPEDCEIvJAUv9UoQgqhfwFRBsMWbvnihFKokGiSoqa2N2e55e2bGi7O72cQIIg4Mz8wDz4//DDOPnF3dbGM60CKLrApoGdAqMBtrVaGlYpP7ca5VQIuAViGYhdvSeyQk873W2wu95rPi81LmRlko9Wns50qRO2WulIVhuWIYKoZFinM3+Oin9/3yi2vJQj99/cxSP9YqIsucUQZZBqPRrDujBBAIDh6gFAgxEAPlNrBTEsl60mvG8SCNKYDUhLZDLpAJ5DHkDciakKWQtSDrwChz8h6YAQjabfNLTlqYd5PlY3D+UbCywCTBJcaU2h3c6oe1O2qgCsHAyxJz4Y/dhDffibl5A5JOAx5oZujVj5DBEswtIg8+jLS6HGWO4Dvb2PAevnMV7y/w20NP02kJAJGbQxRjlVN8cIFi9Q1878+/YdwdVSc4lD/cpHzrNapLH1N5ShUcc6+BuEHcJDq5gv/8O7a5XXf/AAzcHTPHDTwI9v0GPorQ48uoAWNg4jYmL62QXlhDogYyf2IfNwOrgQF77An8vXVMwNo97L5OeCQ+jmRwinhw6mChXqubwtwxNbw9h58+U9+roru7+FThBH24a1OYTYFmhs2onfUJJsL838PGsTpYFKMSYw6qNquwhuitG+jXX4CnxOdfwTtzRyoxBLY2iNY/RY61qZ55CWNuKiaaluyBsP4h1dq72HBvOshHAX17k8YnqyTffYmJMNu1WmExRL/9jOjcU+B9XP65XHNDuh2ql1+lEX6ltXUFFp+fAZpB2iF58gV4bhFvH8fiJuKG1Hsxnso6RgN2+ixh+XHCnQ0sbkLYn9vk9r2Cbzb2CLqC7iiqGRqGaDBUFVObxqpWj42D47j3cXf27t9hVBggJJeu/Xjx86+u97SsIq0UDTr+YBWdeKhPqxSrv5jD+x1lw7tbIKUACdA9tG//1Yr/gXHQ/gJla4L5jBzrYgAAACJ6VFh0U29mdHdhcmUAAHjac0zJT0pV8MxNTE8NSk1MqQQAL5wF1K4MqU0AAAAASUVORK5CYII="));
    private MouseMotionListener mml = new MouseMotionAdapter(){

        public void mouseMoved(MouseEvent mouseEvent) {
            FullScreen.this.hideClosePanelTimer.restart();
            FullScreen.this.closePanel.setVisible(true);
        }
    };
    private MouseListener ml = new MouseAdapter(){

        public void mouseEntered(MouseEvent mouseEvent) {
            FullScreen.this.locked = true;
        }

        public void mouseExited(MouseEvent mouseEvent) {
            FullScreen.this.locked = false;
        }
    };

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.hideClosePanelTimer) {
            if (!this.locked && this.closePanel.isVisible()) {
                this.closePanel.setVisible(false);
                this.getContentPane().repaint();
            }
        } else {
            this.returnFromFullScreenMode();
        }
    }

    public FullScreen() {
        this.listeners = new LinkedList<FullScreenListener>();
        this.gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        this.zoomPane = new ZoomPane();
        this.zoomPane.setRoot((JComponent)this.getGlassPane());
        this.getContentPane().setLayout(new BorderLayout());
        JButton jButton = new JButton(noFullScreenIcon);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(this);
        this.getContentPane().add((Component)this.zoomPane, "Center");
        this.addKeyListener(this);
        this.setUndecorated(true);
        this.scalePanel = new ScalePanel(true);
        this.scalePanel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        this.scalePanel.getSlider().addMouseListener(this.ml);
        this.scalePanel.setScalable(this.zoomPane);
        this.closePanel = new JPanel();
        this.closePanel.setLayout(new BorderLayout());
        this.closePanel.add((Component)jButton, "East");
        this.closePanel.add((Component)this.scalePanel, "Center");
        JPanel jPanel = (JPanel)this.getGlassPane();
        jPanel.setVisible(true);
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "North");
        jPanel2.add((Component)this.closePanel, "East");
        this.hideClosePanelTimer = new Timer(1000, this);
        this.hideClosePanelTimer.start();
    }

    public ZoomPane getZoomPane() {
        return this.zoomPane;
    }

    public void addListener(FullScreenListener fullScreenListener) {
        this.listeners.add(fullScreenListener);
    }

    public ScalePanel getScalePanel() {
        return this.scalePanel;
    }

    public void display(Zoomable<? extends JComponent> zoomable) {
        this.gd.setFullScreenWindow(this);
        this.setVisible(true);
        zoomable.asJComponent().removeMouseMotionListener(this.mml);
        zoomable.asJComponent().addMouseMotionListener(this.mml);
        this.zoomPane.setViewportView(zoomable);
        this.closePanel.setVisible(false);
        this.locked = false;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FullScreen.this.requestFocus();
            }
        });
    }

    private void returnFromFullScreenMode() {
        this.gd.setFullScreenWindow(null);
        for (FullScreenListener fullScreenListener : this.listeners) {
            fullScreenListener.fullScreenModeLeft();
        }
        this.setVisible(false);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27 || KeyEvent.getKeyText(keyEvent.getKeyCode()).equals("F9")) {
            this.returnFromFullScreenMode();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

