/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import javax.swing.SwingUtilities;

public abstract class DelayedActivity
extends Thread {
    private boolean notified;

    protected DelayedActivity() {
        this.setDaemon(true);
    }

    public synchronized void indicateChange() {
        this.notified = true;
        this.notify();
    }

    public void run() {
        boolean bl = false;
        DelayedActivity delayedActivity = this;
        synchronized (delayedActivity) {
            while (true) {
                try {
                    this.wait(Math.max(1, this.getDelay()));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.notified) {
                    bl = true;
                } else if (bl) {
                    if (SwingUtilities.isEventDispatchThread()) {
                        this.perform();
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                DelayedActivity.this.perform();
                            }
                        });
                    }
                    bl = false;
                }
                this.notified = false;
            }
        }
    }

    protected abstract int getDelay();

    protected abstract void perform();
}

