/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class ButtonPanel
extends JPanel {
    private static final long serialVersionUID = 2123185410505818217L;
    private int maxWidth;
    private int maxHeight;
    private JButton defaultButton;
    private static final int BORDER_WIDTH = 5;
    private static final int GAP_WIDTH = 8;

    public ButtonPanel(ComponentOrientation componentOrientation) {
        this.setLayout(new BoxLayout(this, 2));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setComponentOrientation(componentOrientation);
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                ButtonPanel.this.setDefaultButton();
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }
        });
    }

    private void setDefaultButton() {
        if (this.defaultButton != null) {
            Container container;
            for (container = this; container != null && !(container instanceof JRootPane); container = container.getParent()) {
            }
            if (container != null) {
                ((JRootPane)container).setDefaultButton(this.defaultButton);
                this.defaultButton = null;
            }
        }
    }

    public ButtonPanel() {
        this(ComponentOrientation.RIGHT_TO_LEFT);
    }

    public void addAction(Action action) {
        this.addAction(action, 0, false);
    }

    public void addAction(Action action, int n, boolean bl) {
        JButton jButton = new JButton(action);
        this.maxWidth = Math.max(this.maxWidth, jButton.getPreferredSize().width);
        this.maxHeight = Math.max(this.maxHeight, jButton.getPreferredSize().height);
        this.add(jButton);
        this.add(Box.createRigidArea(new Dimension(8, 1)));
        if (n > 0) {
            this.add(Box.createRigidArea(new Dimension(n, 1)));
        }
        Dimension dimension = new Dimension(this.maxWidth, this.maxHeight);
        for (Component component : this.getComponents()) {
            if (!(component instanceof JButton)) continue;
            JButton jButton2 = (JButton)component;
            jButton2.setMinimumSize(dimension);
            jButton2.setPreferredSize(dimension);
            jButton2.setMaximumSize(dimension);
        }
        if (bl) {
            this.defaultButton = jButton;
            this.setDefaultButton();
        }
    }
}

