/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;

public class AutoCompletion
extends KeyAdapter {
    private ArrayList<String> suggestions;
    private int counter;
    private JTextPane textArea;
    private SuggestionProvider provider;
    private int wordBegin;
    private int wordEnd;
    private State state;
    private char[] delimiters;

    public AutoCompletion(JTextPane jTextPane, SuggestionProvider suggestionProvider, char ... cArray) {
        this.textArea = jTextPane;
        jTextPane.addKeyListener(this);
        this.provider = suggestionProvider;
        this.suggestions = new ArrayList();
        this.delimiters = cArray;
        this.state = State.INIT;
    }

    private boolean isLimit(char c) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        for (char c2 : this.delimiters) {
            if (c2 != c) continue;
            return true;
        }
        return false;
    }

    private boolean isTrigger(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 9 || keyEvent.getKeyCode() == 32 && keyEvent.isShiftDown() && keyEvent.isControlDown();
    }

    private String findPrefix() {
        char c;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        this.wordEnd = n + 1;
        String string = this.textArea.getText();
        for (n = this.textArea.getCaretPosition() - 1; n >= 0 && !this.isLimit(c = string.charAt(n)); --n) {
            stringBuffer.insert(0, c);
        }
        this.wordBegin = n + 1;
        String string2 = stringBuffer.toString().trim();
        return string2;
    }

    private boolean tabPressed() {
        boolean bl = false;
        if (this.state == State.INIT) {
            String string = this.findPrefix();
            if (string.length() > 0) {
                this.suggestions.clear();
                this.suggestions.addAll(this.provider.getSuggestions(string));
                if (this.suggestions.size() > 0) {
                    this.replaceBy(this.suggestions.get(0));
                    bl = true;
                }
                if (this.suggestions.size() > 1) {
                    this.counter = 0;
                    this.state = State.CHOOSING;
                }
            }
        } else if (this.suggestions.size() > 0) {
            bl = true;
            this.counter = (this.counter + 1) % this.suggestions.size();
            this.replaceBy(this.suggestions.get(this.counter));
        }
        return bl;
    }

    private void replaceBy(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AutoCompletion.this.textArea.setSelectionStart(AutoCompletion.this.wordBegin);
                AutoCompletion.this.textArea.setSelectionEnd(AutoCompletion.this.wordEnd);
                AutoCompletion.this.textArea.replaceSelection(string);
                AutoCompletion.this.wordEnd = AutoCompletion.this.wordBegin + string.length();
            }
        });
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.isTrigger(keyEvent)) {
            String string = this.textArea.getText();
            int n = this.textArea.getCaretPosition();
            if (string.length() > 0 && !Character.isWhitespace(string.charAt(n - 1)) && (n == string.length() || this.isLimit(string.charAt(n))) && this.tabPressed()) {
                keyEvent.consume();
            }
        } else {
            this.state = State.INIT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SuggestionProvider {
        public List<String> getSuggestions(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INIT,
        CHOOSING;

    }
}

