/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import net.sf.sdedit.ui.components.GrabbableViewport;
import net.sf.sdedit.util.Browser;

public class AdvancedHelpPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
TreeCellRenderer {
    private static final long serialVersionUID = 421111139685691723L;
    private JScrollPane navigatorScrollPane;
    private JScrollPane contentScrollPane;
    private JEditorPane editorPane;
    private JTree navigator;
    private DefaultTreeModel navigatorModel;
    private DefaultMutableTreeNode navigatorRoot;
    private static Pattern pattern = Pattern.compile(".*<a name=\"(.+?)\">(.*?)<\\/a.*");
    private Map<String, DefaultMutableTreeNode> anchorMap;
    private String url;
    private static Font[] fonts;
    private static Cursor HAND;
    private static Cursor DEFAULT;

    public AdvancedHelpPanel(URL uRL, HyperlinkListener hyperlinkListener) {
        this.init();
        this.url = uRL.toString();
        this.anchorMap = new HashMap<String, DefaultMutableTreeNode>();
        try {
            this.readAnchors(uRL);
            this.editorPane.setPage(uRL);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.navigatorModel.nodeStructureChanged(this.navigatorRoot);
        this.expandNavigator();
        this.navigator.addMouseListener(this);
        this.navigator.addMouseMotionListener(this);
        this.editorPane.addHyperlinkListener(Browser.getBrowser());
        this.editorPane.addHyperlinkListener(hyperlinkListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAnchors(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            while (string != null) {
                this.searchAnchors(string);
                string = bufferedReader.readLine();
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    private void searchAnchors(String string) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            this.addAnchor(string2, string3);
        }
    }

    private DefaultMutableTreeNode addAnchor(String string, String string2) {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode;
        int n = string.lastIndexOf(46);
        if (n == -1) {
            defaultMutableTreeNode = this.navigatorRoot;
        } else {
            object = string.substring(0, n);
            defaultMutableTreeNode = this.anchorMap.get(object);
            if (defaultMutableTreeNode == null) {
                defaultMutableTreeNode = this.addAnchor((String)object, "");
            }
        }
        object = new UserObject(string, string2);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(object);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.anchorMap.put(string, defaultMutableTreeNode2);
        return defaultMutableTreeNode2;
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.navigatorScrollPane = new JScrollPane();
        this.contentScrollPane = new JScrollPane();
        this.editorPane = new JEditorPane(){

            protected void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                super.paintComponent(graphics);
            }
        };
        this.editorPane.setContentType("text/html; charset=ISO-8859-1");
        this.editorPane.setEditable(false);
        GrabbableViewport grabbableViewport = new GrabbableViewport();
        ((JViewport)grabbableViewport).setView(this.editorPane);
        this.contentScrollPane.setViewport(grabbableViewport);
        Border border = BorderFactory.createEmptyBorder(5, 5, 0, 10);
        this.add((Component)this.navigatorScrollPane, "West");
        Border border2 = BorderFactory.createEtchedBorder(0);
        this.navigatorScrollPane.setBorder(border2);
        this.add((Component)this.contentScrollPane, "Center");
        this.navigatorRoot = new DefaultMutableTreeNode();
        this.navigatorModel = new DefaultTreeModel(this.navigatorRoot);
        this.navigator = new JTree(){

            protected void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                super.paintComponent(graphics);
            }
        };
        this.navigator.setBorder(border);
        this.navigator.setCellRenderer(this);
        this.navigator.setModel(this.navigatorModel);
        this.navigator.setRootVisible(false);
        this.navigatorScrollPane.setViewportView(this.navigator);
    }

    private void expandNavigator() {
        int n = 0;
        while (this.navigator.getRowCount() != n) {
            n = this.navigator.getRowCount();
            for (int i = 0; i < n; ++i) {
                this.navigator.expandRow(i);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        TreePath treePath = this.navigator.getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            UserObject userObject = (UserObject)defaultMutableTreeNode.getUserObject();
            String string = userObject.id;
            try {
                this.editorPane.setPage(this.url + "#" + string);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        mouseEvent.consume();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private static int countDots(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '.') continue;
            ++n;
        }
        return n;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
        JLabel jLabel = new JLabel();
        if (!(object2 instanceof UserObject)) {
            return jLabel;
        }
        UserObject userObject = (UserObject)object2;
        int n2 = Math.min(AdvancedHelpPanel.countDots(userObject.id), fonts.length - 1);
        jLabel.setFont(fonts[n2]);
        jLabel.setText("<html><u>" + userObject.content + "</u>");
        return jLabel;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        TreePath treePath = this.navigator.getPathForLocation(n2, n = mouseEvent.getY());
        if (treePath != null) {
            this.navigator.setCursor(HAND);
        } else {
            this.navigator.setCursor(DEFAULT);
        }
    }

    static {
        HAND = Cursor.getPredefinedCursor(12);
        DEFAULT = Cursor.getPredefinedCursor(0);
        fonts = new Font[3];
        String string = "Dialog";
        AdvancedHelpPanel.fonts[0] = new Font(string, 1, 13);
        AdvancedHelpPanel.fonts[1] = new Font(string, 0, 13);
        AdvancedHelpPanel.fonts[2] = new Font(string, 0, 12);
    }

    private static class UserObject {
        private String id;
        private String content;

        UserObject(String string, String string2) {
            this.id = string;
            this.content = string2;
        }

        public String toString() {
            return this.content;
        }
    }
}

